/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.PlanExecutor;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.ShutdownHookUtil;
import org.slf4j.Logger;

@Public
public class RemoteEnvironment
extends ExecutionEnvironment {
    protected final String host;
    protected final int port;
    protected final List<URL> jarFiles;
    protected Configuration clientConfiguration;
    protected PlanExecutor executor;
    private Thread shutdownHook;
    protected final List<URL> globalClasspaths;

    public RemoteEnvironment(String host, int port, String ... jarFiles) {
        this(host, port, (Configuration)null, jarFiles, (URL[])null);
    }

    public RemoteEnvironment(String host, int port, Configuration clientConfig, String[] jarFiles) {
        this(host, port, clientConfig, jarFiles, null);
    }

    public RemoteEnvironment(String host, int port, Configuration clientConfig, String[] jarFiles, URL[] globalClasspaths) {
        if (!ExecutionEnvironment.areExplicitEnvironmentsAllowed()) {
            throw new InvalidProgramException("The RemoteEnvironment cannot be instantiated when running in a pre-defined context (such as Command Line Client, Scala Shell, or TestEnvironment)");
        }
        if (host == null) {
            throw new NullPointerException("Host must not be null.");
        }
        if (port < 1 || port >= 65535) {
            throw new IllegalArgumentException("Port out of range");
        }
        this.host = host;
        this.port = port;
        Configuration configuration = this.clientConfiguration = clientConfig == null ? new Configuration() : clientConfig;
        if (jarFiles != null) {
            this.jarFiles = new ArrayList<URL>(jarFiles.length);
            for (String jarFile : jarFiles) {
                try {
                    this.jarFiles.add(new File(jarFile).getAbsoluteFile().toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("JAR file path invalid", e);
                }
            }
        } else {
            this.jarFiles = Collections.emptyList();
        }
        this.globalClasspaths = globalClasspaths == null ? Collections.emptyList() : Arrays.asList(globalClasspaths);
    }

    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        JobExecutionResult result;
        PlanExecutor executor = this.getExecutor();
        Plan p = this.createProgramPlan(jobName);
        this.lastJobExecutionResult = result = executor.executePlan(p);
        return result;
    }

    @Override
    public String getExecutionPlan() throws Exception {
        Plan p = this.createProgramPlan("plan", false);
        if (this.executor != null) {
            return this.executor.getOptimizerPlanAsJSON(p);
        }
        PlanExecutor le = PlanExecutor.createLocalExecutor(null);
        String plan = le.getOptimizerPlanAsJSON(p);
        le.stop();
        return plan;
    }

    @Override
    @PublicEvolving
    public void startNewSession() throws Exception {
        this.dispose();
        this.jobID = JobID.generate();
        this.installShutdownHook();
    }

    protected PlanExecutor getExecutor() throws Exception {
        if (this.executor == null) {
            this.executor = PlanExecutor.createRemoteExecutor((String)this.host, (int)this.port, (Configuration)this.clientConfiguration, this.jarFiles, this.globalClasspaths);
            this.executor.setPrintStatusDuringExecution(this.getConfig().isSysoutLoggingEnabled());
        }
        if (this.getSessionTimeout() > 0L && !this.executor.isRunning()) {
            this.executor.start();
            this.installShutdownHook();
        }
        return this.executor;
    }

    protected void dispose() {
        ShutdownHookUtil.removeShutdownHook((Thread)this.shutdownHook, (String)this.getClass().getSimpleName(), (Logger)LOG);
        try {
            PlanExecutor executor = this.executor;
            if (executor != null) {
                executor.endSession(this.jobID);
                executor.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to dispose the session shutdown hook.");
        }
    }

    public String toString() {
        return "Remote Environment (" + this.host + ":" + this.port + " - parallelism = " + (this.getParallelism() == -1 ? "default" : Integer.valueOf(this.getParallelism())) + ") : " + this.getIdString();
    }

    private void installShutdownHook() {
        if (this.shutdownHook == null) {
            this.shutdownHook = ShutdownHookUtil.addShutdownHook(this::dispose, (String)this.getClass().getSimpleName(), (Logger)LOG);
        }
    }
}

