/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.operators.translation.KeyExtractingMapper;
import org.apache.flink.api.java.operators.translation.KeyRemovingMapper;
import org.apache.flink.api.java.operators.translation.TwoKeyExtractingMapper;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;

@Internal
public class KeyFunctions {
    public static <T, K> Operator<Tuple2<K, T>> appendKeyExtractor(Operator<T> input, Keys.SelectorFunctionKeys<T, K> key) {
        TypeInformation inputType = key.getInputType();
        TypeInformation<Tuple2<K, T>> typeInfoWithKey = KeyFunctions.createTypeWithKey(key);
        KeyExtractingMapper extractor = new KeyExtractingMapper(key.getKeyExtractor());
        MapOperatorBase mapper = new MapOperatorBase(extractor, new UnaryOperatorInformation(inputType, typeInfoWithKey), "Key Extractor");
        mapper.setInput(input);
        mapper.setParallelism(input.getParallelism());
        return mapper;
    }

    public static <T, K1, K2> Operator<Tuple3<K1, K2, T>> appendKeyExtractor(Operator<T> input, Keys.SelectorFunctionKeys<T, K1> key1, Keys.SelectorFunctionKeys<T, K2> key2) {
        TypeInformation inputType = key1.getInputType();
        TypeInformation<Tuple3<K1, K2, T>> typeInfoWithKey = KeyFunctions.createTypeWithKey(key1, key2);
        TwoKeyExtractingMapper extractor = new TwoKeyExtractingMapper(key1.getKeyExtractor(), key2.getKeyExtractor());
        MapOperatorBase mapper = new MapOperatorBase(extractor, new UnaryOperatorInformation(inputType, typeInfoWithKey), "Key Extractor");
        mapper.setInput(input);
        mapper.setParallelism(input.getParallelism());
        return mapper;
    }

    public static <T, K> SingleInputOperator<?, T, ?> appendKeyRemover(Operator<Tuple2<K, T>> inputWithKey, Keys.SelectorFunctionKeys<T, K> key) {
        TypeInformation inputType = key.getInputType();
        TypeInformation<Tuple2<K, T>> typeInfoWithKey = KeyFunctions.createTypeWithKey(key);
        MapOperatorBase mapper = new MapOperatorBase(new KeyRemovingMapper(), new UnaryOperatorInformation(typeInfoWithKey, inputType), "Key Remover");
        mapper.setInput(inputWithKey);
        mapper.setParallelism(inputWithKey.getParallelism());
        return mapper;
    }

    public static <T, K> TypeInformation<Tuple2<K, T>> createTypeWithKey(Keys.SelectorFunctionKeys<T, K> key) {
        return new TupleTypeInfo(new TypeInformation[]{key.getKeyType(), key.getInputType()});
    }

    public static <T, K1, K2> TypeInformation<Tuple3<K1, K2, T>> createTypeWithKey(Keys.SelectorFunctionKeys<T, K1> key1, Keys.SelectorFunctionKeys<T, K2> key2) {
        return new TupleTypeInfo(new TypeInformation[]{key1.getKeyType(), key2.getKeyType(), key1.getInputType()});
    }
}

