/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.optimizer.dag.EstimateProvider;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dag.TempMode;
import org.apache.flink.optimizer.dataproperties.InterestingProperties;
import org.apache.flink.optimizer.plandump.DumpableConnection;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;

public class DagConnection
implements EstimateProvider,
DumpableConnection<OptimizerNode> {
    private final OptimizerNode source;
    private final OptimizerNode target;
    private final ExecutionMode dataExchangeMode;
    private InterestingProperties interestingProps;
    private ShipStrategyType shipStrategy;
    private TempMode materializationMode = TempMode.NONE;
    private int maxDepth = -1;
    private boolean breakPipeline;

    public DagConnection(OptimizerNode source, OptimizerNode target, ExecutionMode exchangeMode) {
        this(source, target, null, exchangeMode);
    }

    public DagConnection(OptimizerNode source, OptimizerNode target, ShipStrategyType shipStrategy, ExecutionMode exchangeMode) {
        if (source == null || target == null) {
            throw new NullPointerException("Source and target must not be null.");
        }
        this.source = source;
        this.target = target;
        this.shipStrategy = shipStrategy;
        this.dataExchangeMode = exchangeMode;
    }

    public DagConnection(OptimizerNode source, ExecutionMode exchangeMode) {
        if (source == null) {
            throw new NullPointerException("Source and target must not be null.");
        }
        this.source = source;
        this.target = null;
        this.shipStrategy = ShipStrategyType.NONE;
        this.dataExchangeMode = exchangeMode;
    }

    public OptimizerNode getSource() {
        return this.source;
    }

    public OptimizerNode getTarget() {
        return this.target;
    }

    @Override
    public ShipStrategyType getShipStrategy() {
        return this.shipStrategy;
    }

    public void setShipStrategy(ShipStrategyType strategy) {
        this.shipStrategy = strategy;
    }

    public ExecutionMode getDataExchangeMode() {
        if (this.dataExchangeMode == null) {
            throw new IllegalStateException("This connection does not have the data exchange mode set");
        }
        return this.dataExchangeMode;
    }

    public void markBreaksPipeline() {
        this.breakPipeline = true;
    }

    public boolean isBreakingPipeline() {
        return this.breakPipeline;
    }

    public InterestingProperties getInterestingProperties() {
        return this.interestingProps;
    }

    public void setInterestingProperties(InterestingProperties props) {
        if (this.interestingProps != null) {
            throw new IllegalStateException("Interesting Properties have already been set.");
        }
        this.interestingProps = props;
    }

    public void clearInterestingProperties() {
        this.interestingProps = null;
    }

    public void initMaxDepth() {
        if (this.maxDepth != -1) {
            throw new IllegalStateException("Maximum path depth has already been initialized.");
        }
        this.maxDepth = this.source.getMaxDepth() + 1;
    }

    public int getMaxDepth() {
        if (this.maxDepth != -1) {
            return this.maxDepth;
        }
        throw new IllegalStateException("Maximum path depth has not been initialized.");
    }

    @Override
    public long getEstimatedOutputSize() {
        return this.source.getEstimatedOutputSize();
    }

    @Override
    public long getEstimatedNumRecords() {
        return this.source.getEstimatedNumRecords();
    }

    @Override
    public float getEstimatedAvgWidthPerOutputRecord() {
        return this.source.getEstimatedAvgWidthPerOutputRecord();
    }

    public TempMode getMaterializationMode() {
        return this.materializationMode;
    }

    public void setMaterializationMode(TempMode materializationMode) {
        this.materializationMode = materializationMode;
    }

    public boolean isOnDynamicPath() {
        return this.source.isOnDynamicPath();
    }

    public int getCostWeight() {
        return this.source.getCostWeight();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(50);
        buf.append("Connection: ");
        if (this.source == null) {
            buf.append("null");
        } else {
            buf.append(this.source.getOperator().getName());
            buf.append('(').append(this.source.getOperatorName()).append(')');
        }
        buf.append(" -> ");
        if (this.shipStrategy != null) {
            buf.append('[');
            buf.append(this.shipStrategy.name());
            buf.append(']').append(' ');
        }
        if (this.target == null) {
            buf.append("null");
        } else {
            buf.append(this.target.getOperator().getName());
            buf.append('(').append(this.target.getOperatorName()).append(')');
        }
        return buf.toString();
    }
}

