/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.factories;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.blocklist.BlocklistUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTrackerImpl;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.OnCompletionActions;
import org.apache.flink.runtime.jobmaster.DefaultExecutionDeploymentReconciler;
import org.apache.flink.runtime.jobmaster.DefaultExecutionDeploymentTracker;
import org.apache.flink.runtime.jobmaster.JobManagerSharedServices;
import org.apache.flink.runtime.jobmaster.JobMaster;
import org.apache.flink.runtime.jobmaster.JobMasterConfiguration;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.JobMasterService;
import org.apache.flink.runtime.jobmaster.SlotPoolServiceSchedulerFactory;
import org.apache.flink.runtime.jobmaster.factories.JobManagerJobMetricGroupFactory;
import org.apache.flink.runtime.jobmaster.factories.JobMasterServiceFactory;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.util.function.FunctionUtils;

public class DefaultJobMasterServiceFactory
implements JobMasterServiceFactory {
    private final Executor executor;
    private final RpcService rpcService;
    private final JobMasterConfiguration jobMasterConfiguration;
    private final JobGraph jobGraph;
    private final HighAvailabilityServices haServices;
    private final SlotPoolServiceSchedulerFactory slotPoolServiceSchedulerFactory;
    private final JobManagerSharedServices jobManagerSharedServices;
    private final HeartbeatServices heartbeatServices;
    private final JobManagerJobMetricGroupFactory jobManagerJobMetricGroupFactory;
    private final FatalErrorHandler fatalErrorHandler;
    private final ClassLoader userCodeClassloader;
    private final ShuffleMaster<?> shuffleMaster;
    private final long initializationTimestamp;

    public DefaultJobMasterServiceFactory(Executor executor, RpcService rpcService, JobMasterConfiguration jobMasterConfiguration, JobGraph jobGraph, HighAvailabilityServices haServices, SlotPoolServiceSchedulerFactory slotPoolServiceSchedulerFactory, JobManagerSharedServices jobManagerSharedServices, HeartbeatServices heartbeatServices, JobManagerJobMetricGroupFactory jobManagerJobMetricGroupFactory, FatalErrorHandler fatalErrorHandler, ClassLoader userCodeClassloader, long initializationTimestamp) {
        this.executor = executor;
        this.rpcService = rpcService;
        this.jobMasterConfiguration = jobMasterConfiguration;
        this.jobGraph = jobGraph;
        this.haServices = haServices;
        this.slotPoolServiceSchedulerFactory = slotPoolServiceSchedulerFactory;
        this.jobManagerSharedServices = jobManagerSharedServices;
        this.heartbeatServices = heartbeatServices;
        this.jobManagerJobMetricGroupFactory = jobManagerJobMetricGroupFactory;
        this.fatalErrorHandler = fatalErrorHandler;
        this.userCodeClassloader = userCodeClassloader;
        this.shuffleMaster = jobManagerSharedServices.getShuffleMaster();
        this.initializationTimestamp = initializationTimestamp;
    }

    @Override
    public CompletableFuture<JobMasterService> createJobMasterService(UUID leaderSessionId, OnCompletionActions onCompletionActions) {
        return CompletableFuture.supplyAsync(FunctionUtils.uncheckedSupplier(() -> this.internalCreateJobMasterService(leaderSessionId, onCompletionActions)), this.executor);
    }

    private JobMasterService internalCreateJobMasterService(UUID leaderSessionId, OnCompletionActions onCompletionActions) throws Exception {
        JobMaster jobMaster = new JobMaster(this.rpcService, JobMasterId.fromUuidOrNull(leaderSessionId), this.jobMasterConfiguration, ResourceID.generate(), this.jobGraph, this.haServices, this.slotPoolServiceSchedulerFactory, this.jobManagerSharedServices, this.heartbeatServices, this.jobManagerJobMetricGroupFactory, onCompletionActions, this.fatalErrorHandler, this.userCodeClassloader, this.shuffleMaster, lookup -> new JobMasterPartitionTrackerImpl(this.jobGraph.getJobID(), this.shuffleMaster, lookup), new DefaultExecutionDeploymentTracker(), DefaultExecutionDeploymentReconciler::new, BlocklistUtils.loadBlocklistHandlerFactory(this.jobMasterConfiguration.getConfiguration()), this.initializationTimestamp);
        jobMaster.start();
        return jobMaster;
    }
}

