/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.security.token.DelegationTokenManager;
import org.apache.flink.util.Preconditions;

public class ResourceManagerProcessContext {
    private final Configuration rmConfig;
    private final ResourceID resourceId;
    private final ResourceManagerRuntimeServicesConfiguration rmRuntimeServicesConfig;
    private final RpcService rpcService;
    private final HighAvailabilityServices highAvailabilityServices;
    private final HeartbeatServices heartbeatServices;
    private final DelegationTokenManager delegationTokenManager;
    private final FatalErrorHandler fatalErrorHandler;
    private final ClusterInformation clusterInformation;
    @Nullable
    private final String webInterfaceUrl;
    private final MetricRegistry metricRegistry;
    private final String hostname;
    private final Executor ioExecutor;

    public ResourceManagerProcessContext(Configuration rmConfig, ResourceID resourceId, ResourceManagerRuntimeServicesConfiguration rmRuntimeServicesConfig, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, DelegationTokenManager delegationTokenManager, FatalErrorHandler fatalErrorHandler, ClusterInformation clusterInformation, @Nullable String webInterfaceUrl, MetricRegistry metricRegistry, String hostname, Executor ioExecutor) {
        this.rmConfig = (Configuration)Preconditions.checkNotNull((Object)rmConfig);
        this.resourceId = (ResourceID)Preconditions.checkNotNull((Object)resourceId);
        this.rmRuntimeServicesConfig = (ResourceManagerRuntimeServicesConfiguration)Preconditions.checkNotNull((Object)rmRuntimeServicesConfig);
        this.rpcService = (RpcService)Preconditions.checkNotNull((Object)rpcService);
        this.highAvailabilityServices = (HighAvailabilityServices)Preconditions.checkNotNull((Object)highAvailabilityServices);
        this.heartbeatServices = (HeartbeatServices)Preconditions.checkNotNull((Object)heartbeatServices);
        this.delegationTokenManager = (DelegationTokenManager)Preconditions.checkNotNull((Object)delegationTokenManager);
        this.fatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fatalErrorHandler);
        this.clusterInformation = (ClusterInformation)Preconditions.checkNotNull((Object)clusterInformation);
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.ioExecutor = (Executor)Preconditions.checkNotNull((Object)ioExecutor);
        this.webInterfaceUrl = webInterfaceUrl;
    }

    public Configuration getRmConfig() {
        return this.rmConfig;
    }

    public ResourceID getResourceId() {
        return this.resourceId;
    }

    public ResourceManagerRuntimeServicesConfiguration getRmRuntimeServicesConfig() {
        return this.rmRuntimeServicesConfig;
    }

    public RpcService getRpcService() {
        return this.rpcService;
    }

    public HighAvailabilityServices getHighAvailabilityServices() {
        return this.highAvailabilityServices;
    }

    public HeartbeatServices getHeartbeatServices() {
        return this.heartbeatServices;
    }

    public DelegationTokenManager getDelegationTokenManager() {
        return this.delegationTokenManager;
    }

    public FatalErrorHandler getFatalErrorHandler() {
        return this.fatalErrorHandler;
    }

    public ClusterInformation getClusterInformation() {
        return this.clusterInformation;
    }

    @Nullable
    public String getWebInterfaceUrl() {
        return this.webInterfaceUrl;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Executor getIoExecutor() {
        return this.ioExecutor;
    }
}

