/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.TestingDefaultExecutionGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphBuilder;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorResource;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TernaryBoolean;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class CheckpointSettingsSerializableTest
extends TestLogger {
    @ClassRule
    public static final TestExecutorResource<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorResource();

    @Test
    public void testDeserializationOfUserCodeWithUserClassLoader() throws Exception {
        ClassLoaderUtils.ObjectAndClassLoader outsideClassLoading = ClassLoaderUtils.createSerializableObjectFromNewClassLoader();
        ClassLoader classLoader = outsideClassLoading.getClassLoader();
        Serializable outOfClassPath = (Serializable)outsideClassLoading.getObject();
        MasterTriggerRestoreHook.Factory[] hooks = new MasterTriggerRestoreHook.Factory[]{new TestFactory(outOfClassPath)};
        SerializedValue serHooks = new SerializedValue((Object)hooks);
        JobCheckpointingSettings checkpointingSettings = new JobCheckpointingSettings(new CheckpointCoordinatorConfiguration(1000L, 10000L, 0L, 1, CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION, true, false, 0, 0L), new SerializedValue((Object)new CustomStateBackend(outOfClassPath)), TernaryBoolean.UNDEFINED, new SerializedValue((Object)new CustomCheckpointStorage(outOfClassPath)), serHooks);
        JobGraph jobGraph = JobGraphBuilder.newStreamingJobGraphBuilder().setJobCheckpointingSettings(checkpointingSettings).build();
        JobGraph copy = (JobGraph)CommonTestUtils.createCopySerializable((Serializable)jobGraph);
        DefaultExecutionGraph eg = TestingDefaultExecutionGraphBuilder.newBuilder().setJobGraph(copy).setUserClassLoader(classLoader).build((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor());
        Assert.assertEquals((long)1L, (long)eg.getCheckpointCoordinator().getNumberOfRegisteredMasterHooks());
        Assert.assertTrue((boolean)(jobGraph.getCheckpointingSettings().getDefaultStateBackend().deserializeValue(classLoader) instanceof CustomStateBackend));
    }

    private static final class CustomCheckpointStorage
    implements CheckpointStorage {
        private static final long serialVersionUID = -6107964383429395816L;
        private Serializable customOption;

        public CustomCheckpointStorage(Serializable customOption) {
            this.customOption = customOption;
        }

        public CompletedCheckpointStorageLocation resolveCheckpoint(String pointer) throws IOException {
            throw new UnsupportedOperationException();
        }

        public CheckpointStorageAccess createCheckpointStorage(JobID jobId) throws IOException {
            return (CheckpointStorageAccess)Mockito.mock(CheckpointStorageAccess.class);
        }
    }

    private static final class CustomStateBackend
    implements StateBackend {
        private static final long serialVersionUID = -6107964383429395816L;
        private Serializable customOption;

        public CustomStateBackend(Serializable customOption) {
            this.customOption = customOption;
        }

        public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry, TtlTimeProvider ttlTimeProvider, MetricGroup metricGroup, @Nonnull Collection<KeyedStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) throws Exception {
            throw new UnsupportedOperationException();
        }

        public OperatorStateBackend createOperatorStateBackend(Environment env, String operatorIdentifier, @Nonnull Collection<OperatorStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    private static final class TestFactory
    implements MasterTriggerRestoreHook.Factory {
        private static final long serialVersionUID = -612969579110202607L;
        private final Serializable payload;

        TestFactory(Serializable payload) {
            this.payload = payload;
        }

        public <V> MasterTriggerRestoreHook<V> create() {
            MasterTriggerRestoreHook hook = (MasterTriggerRestoreHook)Mockito.mock(MasterTriggerRestoreHook.class);
            Mockito.when((Object)hook.getIdentifier()).thenReturn((Object)"id");
            return hook;
        }
    }
}

