/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Optional;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SimpleSlotContext;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotInfoTracker;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotInfoTrackerTestUtils;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

abstract class SlotSelectionStrategyTestBase {
    protected final ResourceProfile resourceProfile = ResourceProfile.fromResources((double)2.0, (int)1024);
    protected final ResourceProfile biggerResourceProfile = ResourceProfile.fromResources((double)3.0, (int)1024);
    protected final AllocationID aid1 = new AllocationID();
    protected final AllocationID aid2 = new AllocationID();
    protected final AllocationID aid3 = new AllocationID();
    protected final AllocationID aid4 = new AllocationID();
    protected final AllocationID aidX = new AllocationID();
    protected final TaskManagerLocation tml1 = new TaskManagerLocation(new ResourceID("tm-1"), InetAddress.getLoopbackAddress(), 42);
    protected final TaskManagerLocation tml2 = new TaskManagerLocation(new ResourceID("tm-2"), InetAddress.getLoopbackAddress(), 43);
    protected final TaskManagerLocation tml3 = new TaskManagerLocation(new ResourceID("tm-3"), InetAddress.getLoopbackAddress(), 44);
    protected final TaskManagerLocation tml4 = new TaskManagerLocation(new ResourceID("tm-4"), InetAddress.getLoopbackAddress(), 45);
    protected final TaskManagerLocation tmlX = new TaskManagerLocation(new ResourceID("tm-X"), InetAddress.getLoopbackAddress(), 46);
    protected final TaskManagerGateway taskManagerGateway = new SimpleAckingTaskManagerGateway();
    protected final SlotInfo slotInfo1 = new SimpleSlotContext(this.aid1, this.tml1, 1, this.taskManagerGateway, this.resourceProfile);
    protected final SlotInfo slotInfo2 = new SimpleSlotContext(this.aid2, this.tml2, 2, this.taskManagerGateway, this.biggerResourceProfile);
    protected final SlotInfo slotInfo3 = new SimpleSlotContext(this.aid3, this.tml3, 3, this.taskManagerGateway, this.resourceProfile);
    protected final SlotInfo slotInfo4 = new SimpleSlotContext(this.aid4, this.tml4, 4, this.taskManagerGateway, this.resourceProfile);
    protected final FreeSlotInfoTracker candidates = this.createCandidates();
    protected SlotSelectionStrategy selectionStrategy;

    SlotSelectionStrategyTestBase() {
    }

    private FreeSlotInfoTracker createCandidates() {
        HashMap<AllocationID, SlotInfo> candidates = new HashMap<AllocationID, SlotInfo>(4);
        candidates.put(this.slotInfo1.getAllocationId(), this.slotInfo1);
        candidates.put(this.slotInfo2.getAllocationId(), this.slotInfo2);
        candidates.put(this.slotInfo3.getAllocationId(), this.slotInfo3);
        candidates.put(this.slotInfo4.getAllocationId(), this.slotInfo4);
        return FreeSlotInfoTrackerTestUtils.createDefaultFreeSlotInfoTracker(candidates);
    }

    protected Optional<SlotSelectionStrategy.SlotInfoAndLocality> runMatching(SlotProfile slotProfile) {
        return this.selectionStrategy.selectBestSlotForProfile(this.candidates, slotProfile);
    }
}

