/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerCleanupTest;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.PermanentBlobCache;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.util.FlinkUserCodeClassLoaders;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.UserCodeClassLoader;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BlobLibraryCacheManagerTest
extends TestLogger {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Parameterized.Parameter
    public boolean wrapsSystemClassLoader;

    @Parameterized.Parameters(name="Use system class loader: {0}")
    public static List<Boolean> useSystemClassLoader() {
        return Arrays.asList(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLibraryCacheManagerDifferentJobsCleanup() throws Exception {
        JobID jobId1 = new JobID();
        JobID jobId2 = new JobID();
        ArrayList<PermanentBlobKey> keys1 = new ArrayList<PermanentBlobKey>();
        ArrayList<PermanentBlobKey> keys2 = new ArrayList<PermanentBlobKey>();
        BlobServer server = null;
        PermanentBlobCache cache = null;
        BlobLibraryCacheManager libCache = null;
        byte[] buf = new byte[128];
        try {
            Configuration config = new Configuration();
            config.setLong(BlobServerOptions.CLEANUP_INTERVAL, 1L);
            server = new BlobServer(config, this.temporaryFolder.newFolder(), (BlobStore)new VoidBlobStore());
            server.start();
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            cache = new PermanentBlobCache(config, this.temporaryFolder.newFolder(), (BlobView)new VoidBlobStore(), serverAddress);
            keys1.add(server.putPermanent(jobId1, buf));
            buf[0] = (byte)(buf[0] + 1);
            keys1.add(server.putPermanent(jobId1, buf));
            keys2.add(server.putPermanent(jobId2, buf));
            libCache = this.createBlobLibraryCacheManager(cache);
            cache.registerJob(jobId1);
            cache.registerJob(jobId2);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId1));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(0, jobId1, (PermanentBlobService)cache);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(0, jobId2, (PermanentBlobService)cache);
            LibraryCacheManager.ClassLoaderLease classLoaderLeaseJob1 = libCache.registerClassLoaderLease(jobId1);
            UserCodeClassLoader classLoader1 = classLoaderLeaseJob1.getOrResolveClassLoader(keys1, Collections.emptyList());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId1));
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId2));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId1, keys1, cache, false));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)cache);
            Assert.assertEquals((long)0L, (long)BlobServerCleanupTest.checkFilesExist(jobId2, keys2, cache, false));
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(0, jobId2, (PermanentBlobService)cache);
            LibraryCacheManager.ClassLoaderLease classLoaderLeaseJob2 = libCache.registerClassLoaderLease(jobId2);
            UserCodeClassLoader classLoader2 = classLoaderLeaseJob2.getOrResolveClassLoader(keys2, Collections.emptyList());
            Assert.assertThat((Object)classLoader1, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)classLoader2)));
            try {
                classLoaderLeaseJob2.getOrResolveClassLoader(keys1, Collections.emptyList());
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                classLoaderLeaseJob2.getOrResolveClassLoader(keys2, Collections.singletonList(new URL("file:///tmp/does-not-exist")));
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertEquals((long)2L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId1));
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId2));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId1, keys1, cache, false));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)cache);
            Assert.assertEquals((long)1L, (long)BlobServerCleanupTest.checkFilesExist(jobId2, keys2, cache, false));
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)cache);
            classLoaderLeaseJob1.release();
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId1));
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId2));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId1, keys1, cache, false));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)cache);
            Assert.assertEquals((long)1L, (long)BlobServerCleanupTest.checkFilesExist(jobId2, keys2, cache, false));
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)cache);
            classLoaderLeaseJob2.release();
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId1));
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId2));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId1, keys1, cache, false));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)cache);
            Assert.assertEquals((long)1L, (long)BlobServerCleanupTest.checkFilesExist(jobId2, keys2, cache, false));
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)cache);
        }
        finally {
            if (libCache != null) {
                libCache.shutdown();
            }
            if (cache != null) {
                cache.close();
            }
            if (server != null) {
                server.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLibraryCacheManagerCleanup() throws Exception {
        JobID jobId = new JobID();
        ArrayList<PermanentBlobKey> keys = new ArrayList<PermanentBlobKey>();
        BlobServer server = null;
        PermanentBlobCache cache = null;
        BlobLibraryCacheManager libCache = null;
        byte[] buf = new byte[128];
        try {
            Configuration config = new Configuration();
            config.setLong(BlobServerOptions.CLEANUP_INTERVAL, 1L);
            server = new BlobServer(config, this.temporaryFolder.newFolder(), (BlobStore)new VoidBlobStore());
            server.start();
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            cache = new PermanentBlobCache(config, this.temporaryFolder.newFolder(), (BlobView)new VoidBlobStore(), serverAddress);
            keys.add(server.putPermanent(jobId, buf));
            buf[0] = (byte)(buf[0] + 1);
            keys.add(server.putPermanent(jobId, buf));
            libCache = this.createBlobLibraryCacheManager(cache);
            cache.registerJob(jobId);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(0, jobId, (PermanentBlobService)cache);
            LibraryCacheManager.ClassLoaderLease classLoaderLease1 = libCache.registerClassLoaderLease(jobId);
            UserCodeClassLoader classLoader1 = classLoaderLease1.getOrResolveClassLoader(keys, Collections.emptyList());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
            LibraryCacheManager.ClassLoaderLease classLoaderLease2 = libCache.registerClassLoaderLease(jobId);
            UserCodeClassLoader classLoader2 = classLoaderLease2.getOrResolveClassLoader(keys, Collections.emptyList());
            Assert.assertThat((Object)classLoader1, (Matcher)Matchers.sameInstance((Object)classLoader2));
            try {
                classLoaderLease1.getOrResolveClassLoader(Collections.emptyList(), Collections.emptyList());
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                classLoaderLease1.getOrResolveClassLoader(keys, Collections.singletonList(new URL("file:///tmp/does-not-exist")));
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)2L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
            classLoaderLease1.release();
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
            classLoaderLease2.release();
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
        }
        finally {
            if (libCache != null) {
                libCache.shutdown();
            }
            if (cache != null) {
                cache.close();
            }
            if (server != null) {
                server.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterAndDownload() throws IOException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        JobID jobId = new JobID();
        BlobServer server = null;
        PermanentBlobCache cache = null;
        BlobLibraryCacheManager libCache = null;
        File cacheDir = null;
        try {
            Configuration config = new Configuration();
            config.setLong(BlobServerOptions.CLEANUP_INTERVAL, 1000000L);
            server = new BlobServer(config, this.temporaryFolder.newFolder(), (BlobStore)new VoidBlobStore());
            server.start();
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            cache = new PermanentBlobCache(config, this.temporaryFolder.newFolder(), (BlobView)new VoidBlobStore(), serverAddress);
            PermanentBlobKey dataKey1 = server.putPermanent(jobId, new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
            PermanentBlobKey dataKey2 = server.putPermanent(jobId, new byte[]{11, 12, 13, 14, 15, 16, 17, 18});
            libCache = this.createBlobLibraryCacheManager(cache);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(0, jobId, (PermanentBlobService)cache);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(new JobID()));
            Set<PermanentBlobKey> keys = Collections.singleton(dataKey1);
            cache.registerJob(jobId);
            LibraryCacheManager.ClassLoaderLease classLoaderLease1 = libCache.registerClassLoaderLease(jobId);
            UserCodeClassLoader classLoader1 = classLoaderLease1.getOrResolveClassLoader(keys, Collections.emptyList());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)1L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId, (PermanentBlobService)cache);
            LibraryCacheManager.ClassLoaderLease classLoaderLease2 = libCache.registerClassLoaderLease(jobId);
            UserCodeClassLoader classLoader2 = classLoaderLease2.getOrResolveClassLoader(keys, Collections.emptyList());
            Assert.assertThat((Object)classLoader1, (Matcher)Matchers.sameInstance((Object)classLoader2));
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)2L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)1L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId, (PermanentBlobService)cache);
            classLoaderLease1.release();
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)1L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId, (PermanentBlobService)cache);
            classLoaderLease2.release();
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId, (PermanentBlobService)cache);
            cache.releaseJob(jobId);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId, (PermanentBlobService)cache);
            cacheDir = cache.getStorageLocation(jobId, (BlobKey)new PermanentBlobKey()).getParentFile();
            Assert.assertTrue((boolean)cacheDir.exists());
            Assert.assertTrue((String)"Could not remove write permissions from cache directory", (boolean)cacheDir.setWritable(false, false));
            try {
                cache.registerJob(jobId);
                LibraryCacheManager.ClassLoaderLease classLoaderLease = libCache.registerClassLoaderLease(jobId);
                classLoaderLease.getOrResolveClassLoader(Collections.singleton(dataKey2), Collections.emptyList());
                Assert.fail((String)"This should fail with an IOException");
            }
            catch (IOException e) {
                cache.releaseJob(jobId);
            }
        }
        finally {
            if (cacheDir != null && !cacheDir.setWritable(true, false)) {
                System.err.println("Could not re-add write permissions to cache directory.");
            }
            if (cache != null) {
                cache.close();
            }
            if (libCache != null) {
                libCache.shutdown();
            }
            if (server != null) {
                server.close();
            }
        }
    }

    @Test(expected=IOException.class)
    public void getOrResolveClassLoader_missingBlobKey_shouldFail() throws IOException {
        PermanentBlobKey missingKey = new PermanentBlobKey();
        BlobLibraryCacheManager libraryCacheManager = this.createSimpleBlobLibraryCacheManager();
        LibraryCacheManager.ClassLoaderLease classLoaderLease = libraryCacheManager.registerClassLoaderLease(new JobID());
        classLoaderLease.getOrResolveClassLoader(Collections.singletonList(missingKey), Collections.emptyList());
    }

    @Test(expected=IllegalStateException.class)
    public void getOrResolveClassLoader_closedLease_shouldFail() throws IOException {
        BlobLibraryCacheManager libraryCacheManager = this.createSimpleBlobLibraryCacheManager();
        LibraryCacheManager.ClassLoaderLease classLoaderLease = libraryCacheManager.registerClassLoaderLease(new JobID());
        classLoaderLease.release();
        classLoaderLease.getOrResolveClassLoader(Collections.emptyList(), Collections.emptyList());
    }

    @Test
    public void closingAllLeases_willReleaseUserCodeClassLoader() throws IOException {
        TestingClassLoader classLoader = new TestingClassLoader();
        BlobLibraryCacheManager libraryCacheManager = new TestingBlobLibraryCacheManagerBuilder().setClassLoaderFactory(ignored -> classLoader).build();
        JobID jobId = new JobID();
        LibraryCacheManager.ClassLoaderLease classLoaderLease1 = libraryCacheManager.registerClassLoaderLease(jobId);
        LibraryCacheManager.ClassLoaderLease classLoaderLease2 = libraryCacheManager.registerClassLoaderLease(jobId);
        UserCodeClassLoader userCodeClassLoader = classLoaderLease1.getOrResolveClassLoader(Collections.emptyList(), Collections.emptyList());
        classLoaderLease1.release();
        Assert.assertFalse((boolean)classLoader.isClosed());
        classLoaderLease2.release();
        if (this.wrapsSystemClassLoader) {
            Assert.assertEquals((Object)userCodeClassLoader.asClassLoader(), (Object)ClassLoader.getSystemClassLoader());
            Assert.assertFalse((boolean)classLoader.isClosed());
        } else {
            Assert.assertTrue((boolean)classLoader.isClosed());
        }
    }

    @Test
    public void differentLeasesForSameJob_returnSameClassLoader() throws IOException {
        BlobLibraryCacheManager libraryCacheManager = this.createSimpleBlobLibraryCacheManager();
        JobID jobId = new JobID();
        LibraryCacheManager.ClassLoaderLease classLoaderLease1 = libraryCacheManager.registerClassLoaderLease(jobId);
        LibraryCacheManager.ClassLoaderLease classLoaderLease2 = libraryCacheManager.registerClassLoaderLease(jobId);
        UserCodeClassLoader classLoader1 = classLoaderLease1.getOrResolveClassLoader(Collections.emptyList(), Collections.emptyList());
        UserCodeClassLoader classLoader2 = classLoaderLease2.getOrResolveClassLoader(Collections.emptyList(), Collections.emptyList());
        Assert.assertThat((Object)classLoader1, (Matcher)Matchers.sameInstance((Object)classLoader2));
    }

    @Test(expected=IllegalStateException.class)
    public void closingLibraryCacheManager_invalidatesAllOpenLeases() throws IOException {
        BlobLibraryCacheManager libraryCacheManager = this.createSimpleBlobLibraryCacheManager();
        LibraryCacheManager.ClassLoaderLease classLoaderLease = libraryCacheManager.registerClassLoaderLease(new JobID());
        libraryCacheManager.shutdown();
        classLoaderLease.getOrResolveClassLoader(Collections.emptyList(), Collections.emptyList());
    }

    @Test
    public void closingLibraryCacheManager_closesClassLoader() throws IOException {
        TestingClassLoader classLoader = new TestingClassLoader();
        BlobLibraryCacheManager libraryCacheManager = new TestingBlobLibraryCacheManagerBuilder().setClassLoaderFactory(ignored -> classLoader).build();
        LibraryCacheManager.ClassLoaderLease classLoaderLease = libraryCacheManager.registerClassLoaderLease(new JobID());
        UserCodeClassLoader userCodeClassLoader = classLoaderLease.getOrResolveClassLoader(Collections.emptyList(), Collections.emptyList());
        libraryCacheManager.shutdown();
        if (this.wrapsSystemClassLoader) {
            Assert.assertEquals((Object)userCodeClassLoader.asClassLoader(), (Object)ClassLoader.getSystemClassLoader());
            Assert.assertFalse((boolean)classLoader.isClosed());
        } else {
            Assert.assertTrue((boolean)classLoader.isClosed());
        }
    }

    @Test
    public void releaseUserCodeClassLoader_willRunReleaseHooks() throws IOException, InterruptedException {
        BlobLibraryCacheManager libraryCacheManager = new TestingBlobLibraryCacheManagerBuilder().build();
        LibraryCacheManager.ClassLoaderLease classLoaderLease = libraryCacheManager.registerClassLoaderLease(new JobID());
        UserCodeClassLoader userCodeClassLoader = classLoaderLease.getOrResolveClassLoader(Collections.emptyList(), Collections.emptyList());
        OneShotLatch releaseHookLatch = new OneShotLatch();
        userCodeClassLoader.registerReleaseHookIfAbsent("test", () -> ((OneShotLatch)releaseHookLatch).trigger());
        classLoaderLease.release();
        releaseHookLatch.await();
    }

    @Test
    public void releaseUserCodeClassLoader_willRegisterOnce() throws IOException, InterruptedException {
        BlobLibraryCacheManager libraryCacheManager = new TestingBlobLibraryCacheManagerBuilder().build();
        LibraryCacheManager.ClassLoaderLease classLoaderLease = libraryCacheManager.registerClassLoaderLease(new JobID());
        UserCodeClassLoader userCodeClassLoader = classLoaderLease.getOrResolveClassLoader(Collections.emptyList(), Collections.emptyList());
        OneShotLatch releaseHookLatch = new OneShotLatch();
        userCodeClassLoader.registerReleaseHookIfAbsent("test", () -> ((OneShotLatch)releaseHookLatch).trigger());
        userCodeClassLoader.registerReleaseHookIfAbsent("test", () -> {
            throw new RuntimeException("This hook is not expected to be executed");
        });
        classLoaderLease.release();
        releaseHookLatch.await();
    }

    private BlobLibraryCacheManager createSimpleBlobLibraryCacheManager() throws IOException {
        return new TestingBlobLibraryCacheManagerBuilder().build();
    }

    private BlobLibraryCacheManager createBlobLibraryCacheManager(PermanentBlobCache permanentBlobCache) throws IOException {
        return new TestingBlobLibraryCacheManagerBuilder().setPermanentBlobCache((PermanentBlobService)permanentBlobCache).build();
    }

    private static final class TestingClassLoader
    extends URLClassLoader {
        private boolean isClosed = false;

        private TestingClassLoader() {
            super(new URL[0]);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.isClosed = true;
        }

        private boolean isClosed() {
            return this.isClosed;
        }
    }

    private final class TestingBlobLibraryCacheManagerBuilder {
        private PermanentBlobService permanentBlobCache;
        private BlobLibraryCacheManager.ClassLoaderFactory classLoaderFactory = BlobLibraryCacheManager.defaultClassLoaderFactory((FlinkUserCodeClassLoaders.ResolveOrder)FlinkUserCodeClassLoaders.ResolveOrder.CHILD_FIRST, (String[])new String[0], null, (boolean)true);

        private TestingBlobLibraryCacheManagerBuilder() throws IOException {
            Configuration blobClientConfig = new Configuration();
            this.permanentBlobCache = new PermanentBlobCache(blobClientConfig, BlobLibraryCacheManagerTest.this.temporaryFolder.newFolder(), (BlobView)new VoidBlobStore(), null);
        }

        public TestingBlobLibraryCacheManagerBuilder setPermanentBlobCache(PermanentBlobService permanentBlobCache) {
            this.permanentBlobCache = permanentBlobCache;
            return this;
        }

        public TestingBlobLibraryCacheManagerBuilder setClassLoaderFactory(BlobLibraryCacheManager.ClassLoaderFactory classLoaderFactory) {
            this.classLoaderFactory = classLoaderFactory;
            return this;
        }

        BlobLibraryCacheManager build() {
            return new BlobLibraryCacheManager(this.permanentBlobCache, this.classLoaderFactory, BlobLibraryCacheManagerTest.this.wrapsSystemClassLoader);
        }
    }
}

