/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.executiongraph.failover.flip1.ExponentialDelayRestartBackoffTimeStrategy;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ExponentialDelayRestartBackoffTimeStrategyTest
extends TestLogger {
    private final Exception failure = new Exception();

    @Test
    public void testAlwaysRestart() throws Exception {
        ExponentialDelayRestartBackoffTimeStrategy restartStrategy = new ExponentialDelayRestartBackoffTimeStrategy((Clock)new ManualClock(), 1L, 3L, 2.0, 4L, 0.25);
        for (int i = 0; i < 13; ++i) {
            Assert.assertTrue((boolean)restartStrategy.canRestart());
            restartStrategy.notifyFailure((Throwable)this.failure);
        }
    }

    @Test
    public void testInitialBackoff() throws Exception {
        long initialBackoffMS = 42L;
        ExponentialDelayRestartBackoffTimeStrategy restartStrategy = new ExponentialDelayRestartBackoffTimeStrategy((Clock)new ManualClock(), initialBackoffMS, 45L, 2.0, 8L, 0.0);
        Assert.assertThat((Object)restartStrategy.getBackoffTime(), (Matcher)Matchers.is((Object)initialBackoffMS));
    }

    @Test
    public void testMaxBackoff() throws Exception {
        long maxBackoffMS = 6L;
        ExponentialDelayRestartBackoffTimeStrategy restartStrategy = new ExponentialDelayRestartBackoffTimeStrategy((Clock)new ManualClock(), 1L, 6L, 2.0, 8L, 0.25);
        for (int i = 0; i < 10; ++i) {
            restartStrategy.notifyFailure((Throwable)this.failure);
            Assert.assertThat((Object)restartStrategy.getBackoffTime(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(6L)));
        }
    }

    @Test
    public void testResetBackoff() throws Exception {
        long initialBackoffMS = 1L;
        long resetBackoffThresholdMS = 8L;
        ManualClock clock = new ManualClock();
        ExponentialDelayRestartBackoffTimeStrategy restartStrategy = new ExponentialDelayRestartBackoffTimeStrategy((Clock)clock, 1L, 5L, 2.0, 8L, 0.25);
        clock.advanceTime(8L + restartStrategy.getBackoffTime() - 1L, TimeUnit.MILLISECONDS);
        restartStrategy.notifyFailure((Throwable)this.failure);
        Assert.assertThat((String)"Backoff should be increased", (Object)restartStrategy.getBackoffTime(), (Matcher)Matchers.is((Object)2L));
        clock.advanceTime(8L + restartStrategy.getBackoffTime(), TimeUnit.MILLISECONDS);
        restartStrategy.notifyFailure((Throwable)this.failure);
        Assert.assertThat((String)"Backoff should be reset", (Object)restartStrategy.getBackoffTime(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testBackoffMultiplier() throws Exception {
        long initialBackoffMS = 4L;
        double jitterFactor = 0.0;
        double backoffMultiplier = 2.3;
        long maxBackoffMS = 300L;
        ExponentialDelayRestartBackoffTimeStrategy restartStrategy = new ExponentialDelayRestartBackoffTimeStrategy((Clock)new ManualClock(), initialBackoffMS, maxBackoffMS, backoffMultiplier, 8L, jitterFactor);
        restartStrategy.notifyFailure((Throwable)this.failure);
        Assert.assertThat((Object)restartStrategy.getBackoffTime(), (Matcher)Matchers.is((Object)9L));
        restartStrategy.notifyFailure((Throwable)this.failure);
        Assert.assertThat((Object)restartStrategy.getBackoffTime(), (Matcher)Matchers.is((Object)20L));
    }

    @Test
    public void testJitter() throws Exception {
        long initialBackoffMS = 2L;
        long maxBackoffMS = 7L;
        ExponentialDelayRestartBackoffTimeStrategy restartStrategy = new ExponentialDelayRestartBackoffTimeStrategy((Clock)new ManualClock(), 2L, 7L, 2.0, 1L, 0.25);
        restartStrategy.notifyFailure((Throwable)this.failure);
        this.assertCorrectRandomRange(() -> ((ExponentialDelayRestartBackoffTimeStrategy)restartStrategy).getBackoffTime(), 3L, 4L, 5L);
        restartStrategy.notifyFailure((Throwable)this.failure);
        this.assertCorrectRandomRange(() -> ((ExponentialDelayRestartBackoffTimeStrategy)restartStrategy).getBackoffTime(), 6L, 7L);
        restartStrategy.notifyFailure((Throwable)this.failure);
        this.assertCorrectRandomRange(() -> ((ExponentialDelayRestartBackoffTimeStrategy)restartStrategy).getBackoffTime(), 6L, 7L);
    }

    @Test
    public void testJitterNoHigherThanMax() throws Exception {
        double jitterFactor = 1.0;
        long maxBackoffMS = 7L;
        ExponentialDelayRestartBackoffTimeStrategy restartStrategy = new ExponentialDelayRestartBackoffTimeStrategy((Clock)new ManualClock(), 1L, maxBackoffMS, 2.0, 8L, jitterFactor);
        this.assertCorrectRandomRange(() -> ((ExponentialDelayRestartBackoffTimeStrategy)restartStrategy).getBackoffTime(), 0L, 1L, 2L);
        restartStrategy.notifyFailure((Throwable)this.failure);
        this.assertCorrectRandomRange(() -> ((ExponentialDelayRestartBackoffTimeStrategy)restartStrategy).getBackoffTime(), 0L, 1L, 2L, 3L, 4L);
        restartStrategy.notifyFailure((Throwable)this.failure);
        this.assertCorrectRandomRange(() -> ((ExponentialDelayRestartBackoffTimeStrategy)restartStrategy).getBackoffTime(), 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L);
    }

    @Test
    public void testMultipleSettings() throws Exception {
        ManualClock clock = new ManualClock();
        long initialBackoffMS = 1L;
        long maxBackoffMS = 9L;
        double backoffMultiplier = 2.0;
        long resetBackoffThresholdMS = 8L;
        double jitterFactor = 0.25;
        ExponentialDelayRestartBackoffTimeStrategy restartStrategy = new ExponentialDelayRestartBackoffTimeStrategy((Clock)clock, 1L, 9L, backoffMultiplier, 8L, jitterFactor);
        Assert.assertTrue((boolean)restartStrategy.canRestart());
        Assert.assertThat((Object)restartStrategy.getBackoffTime(), (Matcher)Matchers.is((Object)1L));
        clock.advanceTime(50L, TimeUnit.MILLISECONDS);
        restartStrategy.notifyFailure((Throwable)this.failure);
        Assert.assertTrue((boolean)restartStrategy.canRestart());
        Assert.assertThat((Object)restartStrategy.getBackoffTime(), (Matcher)Matchers.is((Object)1L));
        clock.advanceTime(4L, TimeUnit.MILLISECONDS);
        restartStrategy.notifyFailure((Throwable)this.failure);
        Assert.assertTrue((boolean)restartStrategy.canRestart());
        Assert.assertThat((Object)restartStrategy.getBackoffTime(), (Matcher)Matchers.is((Object)2L));
        clock.advanceTime(3L, TimeUnit.MILLISECONDS);
        restartStrategy.notifyFailure((Throwable)this.failure);
        Assert.assertTrue((boolean)restartStrategy.canRestart());
        this.assertCorrectRandomRange(() -> ((ExponentialDelayRestartBackoffTimeStrategy)restartStrategy).getBackoffTime(), 3L, 4L, 5L);
        clock.advanceTime(7L, TimeUnit.MILLISECONDS);
        restartStrategy.notifyFailure((Throwable)this.failure);
        Assert.assertTrue((boolean)restartStrategy.canRestart());
        this.assertCorrectRandomRange(() -> ((ExponentialDelayRestartBackoffTimeStrategy)restartStrategy).getBackoffTime(), 6L, 7L, 8L, 9L);
        clock.advanceTime(18L, TimeUnit.MILLISECONDS);
        restartStrategy.notifyFailure((Throwable)this.failure);
        Assert.assertTrue((boolean)restartStrategy.canRestart());
        Assert.assertThat((Object)restartStrategy.getBackoffTime(), (Matcher)Matchers.is((Object)1L));
        restartStrategy.notifyFailure((Throwable)this.failure);
        Assert.assertTrue((boolean)restartStrategy.canRestart());
        Assert.assertThat((Object)restartStrategy.getBackoffTime(), (Matcher)Matchers.is((Object)2L));
    }

    private void assertCorrectRandomRange(Callable<Long> numberGenerator, Long ... expectedNumbers) throws Exception {
        HashSet<Long> generatedNumbers = new HashSet<Long>();
        for (int i = 0; i < 1000; ++i) {
            long generatedNumber = numberGenerator.call();
            generatedNumbers.add(generatedNumber);
        }
        Assert.assertThat(generatedNumbers, (Matcher)Matchers.is((Matcher)Matchers.equalTo(new HashSet<Long>(Arrays.asList(expectedNumbers)))));
    }
}

