/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverStrategyFactoryLoader;
import org.apache.flink.runtime.executiongraph.failover.flip1.RestartAllFailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.RestartPipelinedRegionFailoverStrategy;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class FailoverStrategyFactoryLoaderTest
extends TestLogger {
    @Test
    public void testLoadRestartAllStrategyFactory() {
        Configuration config = new Configuration();
        config.setString(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY, "full");
        Assert.assertThat((Object)FailoverStrategyFactoryLoader.loadFailoverStrategyFactory((Configuration)config), (Matcher)Matchers.instanceOf(RestartAllFailoverStrategy.Factory.class));
    }

    @Test
    public void testLoadRestartPipelinedRegionStrategyFactory() {
        Configuration config = new Configuration();
        config.setString(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY, "region");
        Assert.assertThat((Object)FailoverStrategyFactoryLoader.loadFailoverStrategyFactory((Configuration)config), (Matcher)Matchers.instanceOf(RestartPipelinedRegionFailoverStrategy.Factory.class));
    }

    @Test
    public void testDefaultFailoverStrategyIsRegion() {
        Configuration config = new Configuration();
        Assert.assertThat((Object)FailoverStrategyFactoryLoader.loadFailoverStrategyFactory((Configuration)config), (Matcher)Matchers.instanceOf(RestartPipelinedRegionFailoverStrategy.Factory.class));
    }

    @Test(expected=IllegalConfigurationException.class)
    public void testLoadFromInvalidConfiguration() {
        Configuration config = new Configuration();
        config.setString(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY, "invalidStrategy");
        FailoverStrategyFactoryLoader.loadFailoverStrategyFactory((Configuration)config);
    }
}

