/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.file;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileIndex;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class ProducerMergedPartitionFileIndexTest {
    private Path indexFilePath;

    ProducerMergedPartitionFileIndexTest() {
    }

    @BeforeEach
    void before(@TempDir Path tempDir) {
        this.indexFilePath = tempDir.resolve(".index");
    }

    @Test
    void testAddBufferAndGetRegion() {
        int numSubpartitions = 5;
        int numBuffersPerSubpartition = 10;
        ProducerMergedPartitionFileIndex partitionFileIndex = new ProducerMergedPartitionFileIndex(numSubpartitions, this.indexFilePath, 256, Long.MAX_VALUE);
        ArrayList<ProducerMergedPartitionFileIndex.FlushedBuffer> flushedBuffers = new ArrayList<ProducerMergedPartitionFileIndex.FlushedBuffer>();
        Tuple2<Integer, Integer> numExpectedRegionsAndMaxBufferIndex = this.generateFlushedBuffers(numSubpartitions, numBuffersPerSubpartition, flushedBuffers);
        partitionFileIndex.addBuffers(flushedBuffers);
        int numExpectedRegions = (Integer)numExpectedRegionsAndMaxBufferIndex.f0;
        int maxBufferIndex = (Integer)numExpectedRegionsAndMaxBufferIndex.f1;
        int numGetRegions = ProducerMergedPartitionFileIndexTest.numGetRegionsFromIndex(numSubpartitions, partitionFileIndex, maxBufferIndex);
        partitionFileIndex.release();
        Assertions.assertThat((int)numExpectedRegions).isEqualTo(numGetRegions);
    }

    private Tuple2<Integer, Integer> generateFlushedBuffers(int numSubpartitions, int numBuffersPerSubpartition, List<ProducerMergedPartitionFileIndex.FlushedBuffer> flushedBuffers) {
        int numExpectedRegions = 0;
        int maxBufferIndex = 0;
        Random random = new Random();
        for (int i = 0; i < numSubpartitions; ++i) {
            int bufferIndex = 0;
            for (int j = 0; j < numBuffersPerSubpartition; ++j) {
                boolean isNextRegionContinuous = (j == 0 || random.nextBoolean()) && j != numBuffersPerSubpartition - 1;
                flushedBuffers.add(new ProducerMergedPartitionFileIndex.FlushedBuffer(i, bufferIndex, 0L, 1L));
                ++bufferIndex;
                if (!isNextRegionContinuous) {
                    ++bufferIndex;
                    ++numExpectedRegions;
                }
                maxBufferIndex = Math.max(bufferIndex, maxBufferIndex);
            }
        }
        return new Tuple2((Object)numExpectedRegions, (Object)maxBufferIndex);
    }

    private static int numGetRegionsFromIndex(int numSubpartitions, ProducerMergedPartitionFileIndex partitionFileIndex, int maxBufferIndex) {
        ArrayList subpartitionFirstBufferIndexes = new ArrayList();
        for (int i = 0; i < numSubpartitions; ++i) {
            subpartitionFirstBufferIndexes.add(new HashSet());
            for (int j = 0; j <= maxBufferIndex; ++j) {
                Optional region = partitionFileIndex.getRegion(new TieredStorageSubpartitionId(i), j);
                if (!region.isPresent()) continue;
                ((Set)subpartitionFirstBufferIndexes.get(i)).add(((ProducerMergedPartitionFileIndex.FixedSizeRegion)region.get()).getFirstBufferIndex());
            }
        }
        return subpartitionFirstBufferIndexes.stream().mapToInt(Set::size).sum();
    }
}

