/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.LeaderInformationRegister;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class LeaderInformationRegisterTest {
    LeaderInformationRegisterTest() {
    }

    @Test
    void testOfWithKnownLeaderInformation() {
        String componentId = "component-id";
        LeaderInformation leaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"address");
        LeaderInformationRegister testInstance = LeaderInformationRegister.of((String)"component-id", (LeaderInformation)leaderInformation);
        Assertions.assertThat((Iterable)testInstance.getRegisteredComponentIds()).containsExactly((Object[])new String[]{"component-id"});
        Assertions.assertThat((Optional)testInstance.forComponentId("component-id")).hasValue((Object)leaderInformation);
    }

    @Test
    void testOfWithEmptyLeaderInformation() {
        String componentId = "component-id";
        LeaderInformationRegister testInstance = LeaderInformationRegister.of((String)"component-id", (LeaderInformation)LeaderInformation.empty());
        Assertions.assertThat((Iterable)testInstance.getRegisteredComponentIds()).isEmpty();
        Assertions.assertThat((Optional)testInstance.forComponentId("component-id")).isNotPresent();
    }

    @Test
    void testMerge() {
        String componentId = "component-id";
        LeaderInformation leaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"address");
        String newComponentId = "new-component-id";
        LeaderInformation newLeaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"new-address");
        LeaderInformationRegister initialRegister = LeaderInformationRegister.of((String)"component-id", (LeaderInformation)leaderInformation);
        LeaderInformationRegister newRegister = LeaderInformationRegister.merge((LeaderInformationRegister)initialRegister, (String)"new-component-id", (LeaderInformation)newLeaderInformation);
        Assertions.assertThat((Object)newRegister).isNotSameAs((Object)initialRegister);
        Assertions.assertThat((Iterable)newRegister.getRegisteredComponentIds()).containsExactlyInAnyOrder((Object[])new String[]{"component-id", "new-component-id"});
        Assertions.assertThat((Optional)newRegister.forComponentId("component-id")).hasValue((Object)leaderInformation);
        Assertions.assertThat((Optional)newRegister.forComponentId("new-component-id")).hasValue((Object)newLeaderInformation);
    }

    @Test
    void testMergeEmptyLeaderInformation() {
        String componentId = "component-id";
        LeaderInformation leaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"address");
        String newComponentId = "new-component-id";
        LeaderInformationRegister initialRegister = LeaderInformationRegister.of((String)"component-id", (LeaderInformation)leaderInformation);
        LeaderInformationRegister newRegister = LeaderInformationRegister.merge((LeaderInformationRegister)initialRegister, (String)"new-component-id", (LeaderInformation)LeaderInformation.empty());
        Assertions.assertThat((Object)newRegister).isNotSameAs((Object)initialRegister);
        Assertions.assertThat((Iterable)newRegister.getRegisteredComponentIds()).containsExactly((Object[])new String[]{"component-id"});
        Assertions.assertThat((Optional)newRegister.forComponentId("new-component-id")).isNotPresent();
    }

    @Test
    void testMergeEmptyLeaderInformationForExistingComponentId() {
        String componentId = "component-id";
        LeaderInformation leaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"address");
        LeaderInformationRegister initialRegister = LeaderInformationRegister.of((String)"component-id", (LeaderInformation)leaderInformation);
        LeaderInformationRegister newRegister = LeaderInformationRegister.merge((LeaderInformationRegister)initialRegister, (String)"component-id", (LeaderInformation)LeaderInformation.empty());
        Assertions.assertThat((Object)newRegister).isNotSameAs((Object)initialRegister);
        Assertions.assertThat((Iterable)newRegister.getRegisteredComponentIds()).isEmpty();
        Assertions.assertThat((Optional)newRegister.forComponentId("component-id")).isNotPresent();
    }

    @Test
    void testMergeKnownLeaderInformationForExistingComponentId() {
        String componentId = "component-id";
        LeaderInformation oldLeaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"old-address");
        LeaderInformationRegister initialRegister = LeaderInformationRegister.of((String)"component-id", (LeaderInformation)oldLeaderInformation);
        LeaderInformation newLeaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"new-address");
        LeaderInformationRegister newRegister = LeaderInformationRegister.merge((LeaderInformationRegister)initialRegister, (String)"component-id", (LeaderInformation)newLeaderInformation);
        Assertions.assertThat((Object)newRegister).isNotSameAs((Object)initialRegister);
        Assertions.assertThat((Iterable)newRegister.getRegisteredComponentIds()).containsExactly((Object[])new String[]{"component-id"});
        Assertions.assertThat((Optional)newRegister.forComponentId("component-id")).hasValue((Object)newLeaderInformation);
    }

    @Test
    void testClear() {
        String componentId = "component-id";
        LeaderInformation leaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"address");
        LeaderInformationRegister initialRegister = LeaderInformationRegister.of((String)"component-id", (LeaderInformation)leaderInformation);
        LeaderInformationRegister newRegister = LeaderInformationRegister.clear((LeaderInformationRegister)initialRegister, (String)"component-id");
        Assertions.assertThat((Object)newRegister).isNotSameAs((Object)initialRegister);
        Assertions.assertThat((Iterable)newRegister.getRegisteredComponentIds()).isEmpty();
        Assertions.assertThat((Optional)newRegister.forComponentId("component-id")).isNotPresent();
    }

    @Test
    void testClearNotRegisteredComponentId() {
        String componentId = "component-id";
        LeaderInformationRegister initialRegister = LeaderInformationRegister.of((String)"component-id", (LeaderInformation)LeaderInformation.known((UUID)UUID.randomUUID(), (String)"address"));
        LeaderInformationRegister newRegister = LeaderInformationRegister.clear((LeaderInformationRegister)initialRegister, (String)"another-component-id");
        Assertions.assertThat((Object)newRegister).isNotSameAs((Object)initialRegister);
        Assertions.assertThat((Iterable)newRegister.getRegisteredComponentIds()).containsExactly((Object[])new String[]{"component-id"});
    }

    @Test
    void testEmptyLeaderInformationFiltering() {
        String componentId = "component-id";
        LeaderInformation leaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"address");
        String componentIdWithEmptyLeaderInformation = "new-component-id";
        HashMap<String, LeaderInformation> records = new HashMap<String, LeaderInformation>();
        records.put("component-id", leaderInformation);
        records.put("new-component-id", LeaderInformation.empty());
        LeaderInformationRegister testInstance = new LeaderInformationRegister(records);
        Assertions.assertThat((Iterable)testInstance.getRegisteredComponentIds()).containsExactly((Object[])new String[]{"component-id"});
        Assertions.assertThat((Optional)testInstance.forComponentId("new-component-id")).isNotPresent();
    }

    @Test
    void testEmptyInstance() {
        Assertions.assertThat((Iterable)LeaderInformationRegister.empty().getRegisteredComponentIds()).isEmpty();
    }

    @Test
    void testForComponentId() {
        String componentId = "component-id";
        LeaderInformation leaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"address");
        Assertions.assertThat((Optional)LeaderInformationRegister.of((String)"component-id", (LeaderInformation)leaderInformation).forComponentId("component-id")).hasValue((Object)leaderInformation);
    }

    @Test
    void testForComponentIdOrEmpty() {
        String componentId = "component-id";
        LeaderInformation leaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"address");
        Assertions.assertThat((Object)LeaderInformationRegister.of((String)"component-id", (LeaderInformation)leaderInformation).forComponentIdOrEmpty("component-id")).isEqualTo((Object)leaderInformation);
    }

    @Test
    void testForComponentIdWithEmptyLeaderInformation() {
        String componentId = "component-id";
        Assertions.assertThat((Optional)LeaderInformationRegister.of((String)"component-id", (LeaderInformation)LeaderInformation.empty()).forComponentId("component-id")).isNotPresent();
    }

    @Test
    void testForComponentIdOrEmptyWithEmptyLeaderInformation() {
        String componentId = "component-id";
        Assertions.assertThat((Object)LeaderInformationRegister.of((String)"component-id", (LeaderInformation)LeaderInformation.empty()).forComponentIdOrEmpty("component-id")).isEqualTo((Object)LeaderInformation.empty());
    }

    @Test
    void testHasLeaderInformation() {
        String componentId = "component-id";
        LeaderInformation leaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"address");
        Assertions.assertThat((boolean)LeaderInformationRegister.of((String)"component-id", (LeaderInformation)leaderInformation).hasLeaderInformation("component-id")).isTrue();
    }

    @Test
    void testHasLeaderInformationWithEmptyLeaderInformation() {
        String componentId = "component-id";
        Assertions.assertThat((boolean)LeaderInformationRegister.of((String)"component-id", (LeaderInformation)LeaderInformation.empty()).hasLeaderInformation("component-id")).isFalse();
    }

    @Test
    void hasNoLeaderInformation() {
        LeaderInformationRegister register = LeaderInformationRegister.empty();
        Assertions.assertThat((boolean)register.hasNoLeaderInformation()).isTrue();
        register = LeaderInformationRegister.of((String)"component-id", (LeaderInformation)LeaderInformation.empty());
        Assertions.assertThat((boolean)register.hasNoLeaderInformation()).isTrue();
        register = LeaderInformationRegister.merge((LeaderInformationRegister)register, (String)"other-component-id", (LeaderInformation)LeaderInformation.known((UUID)UUID.randomUUID(), (String)"address"));
        Assertions.assertThat((boolean)register.hasNoLeaderInformation()).isFalse();
    }
}

