/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderretrieval;

import javax.annotation.Nullable;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriver;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriverFactory;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalEventHandler;
import org.apache.flink.runtime.rpc.FatalErrorHandler;

public class TestingLeaderRetrievalDriver
implements LeaderRetrievalDriver {
    private final LeaderRetrievalEventHandler leaderRetrievalEventHandler;
    private final FatalErrorHandler fatalErrorHandler;

    private TestingLeaderRetrievalDriver(LeaderRetrievalEventHandler leaderRetrievalEventHandler, FatalErrorHandler fatalErrorHandler) {
        this.leaderRetrievalEventHandler = leaderRetrievalEventHandler;
        this.fatalErrorHandler = fatalErrorHandler;
    }

    public void close() throws Exception {
    }

    public void onUpdate(LeaderInformation newLeader) {
        this.leaderRetrievalEventHandler.notifyLeaderAddress(newLeader);
    }

    public void onFatalError(Throwable throwable) {
        this.fatalErrorHandler.onFatalError(throwable);
    }

    public static class TestingLeaderRetrievalDriverFactory
    implements LeaderRetrievalDriverFactory {
        private TestingLeaderRetrievalDriver currentDriver;

        public LeaderRetrievalDriver createLeaderRetrievalDriver(LeaderRetrievalEventHandler leaderEventHandler, FatalErrorHandler fatalErrorHandler) {
            this.currentDriver = new TestingLeaderRetrievalDriver(leaderEventHandler, fatalErrorHandler);
            return this.currentDriver;
        }

        @Nullable
        public TestingLeaderRetrievalDriver getCurrentRetrievalDriver() {
            return this.currentDriver;
        }
    }
}

