/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskManagerJobGroupTest
extends TestLogger {
    private MetricRegistryImpl registry;

    @Before
    public void setup() {
        this.registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
    }

    @After
    public void teardown() throws Exception {
        if (this.registry != null) {
            this.registry.closeAsync().get();
        }
    }

    @Test
    public void testGenerateScopeDefault() {
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"theHostName", (ResourceID)new ResourceID("test-tm-id"));
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup((MetricRegistry)this.registry, tmGroup, new JobID(), "myJobName");
        Assert.assertArrayEquals((Object[])new String[]{"theHostName", "taskmanager", "test-tm-id", "myJobName"}, (Object[])jmGroup.getScopeComponents());
        Assert.assertEquals((Object)"theHostName.taskmanager.test-tm-id.myJobName.name", (Object)jmGroup.getMetricIdentifier("name"));
    }

    @Test
    public void testGenerateScopeCustom() throws Exception {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_TM, "abc");
        cfg.setString(MetricOptions.SCOPE_NAMING_TM_JOB, "some-constant.<job_name>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        JobID jid = new JobID();
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"theHostName", (ResourceID)new ResourceID("test-tm-id"));
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup((MetricRegistry)registry, tmGroup, jid, "myJobName");
        Assert.assertArrayEquals((Object[])new String[]{"some-constant", "myJobName"}, (Object[])jmGroup.getScopeComponents());
        Assert.assertEquals((Object)"some-constant.myJobName.name", (Object)jmGroup.getMetricIdentifier("name"));
        registry.closeAsync().get();
    }

    @Test
    public void testGenerateScopeCustomWildcard() throws Exception {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_TM, "peter.<tm_id>");
        cfg.setString(MetricOptions.SCOPE_NAMING_TM_JOB, "*.some-constant.<job_id>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        JobID jid = new JobID();
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"theHostName", (ResourceID)new ResourceID("test-tm-id"));
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup((MetricRegistry)registry, tmGroup, jid, "myJobName");
        Assert.assertArrayEquals((Object[])new String[]{"peter", "test-tm-id", "some-constant", jid.toString()}, (Object[])jmGroup.getScopeComponents());
        Assert.assertEquals((Object)("peter.test-tm-id.some-constant." + jid + ".name"), (Object)jmGroup.getMetricIdentifier("name"));
        registry.closeAsync().get();
    }

    @Test
    public void testCreateQueryServiceMetricInfo() {
        JobID jid = new JobID();
        TaskManagerMetricGroup tm = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"host", (ResourceID)new ResourceID("id"));
        TaskManagerJobMetricGroup job = new TaskManagerJobMetricGroup((MetricRegistry)this.registry, tm, jid, "jobname");
        QueryScopeInfo.JobQueryScopeInfo info = job.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assert.assertEquals((Object)"", (Object)info.scope);
        Assert.assertEquals((Object)jid.toString(), (Object)info.jobID);
    }
}

