/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdActions;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;

public class TestingJobLeaderIdService
implements JobLeaderIdService {
    private final Consumer<JobLeaderIdActions> startConsumer;
    private final Runnable stopRunnable;
    private final Runnable clearRunnable;
    private final Consumer<JobID> addJobConsumer;
    private final Consumer<JobID> removeJobConsumer;
    private final Function<JobID, Boolean> containsJobFunction;
    private final Function<JobID, CompletableFuture<JobMasterId>> getLeaderIdFunction;
    private final BiFunction<JobID, UUID, Boolean> isValidTimeoutFunction;

    private TestingJobLeaderIdService(Consumer<JobLeaderIdActions> startConsumer, Runnable stopRunnable, Runnable clearRunnable, Consumer<JobID> addJobConsumer, Consumer<JobID> removeJobConsumer, Function<JobID, Boolean> containsJobFunction, Function<JobID, CompletableFuture<JobMasterId>> getLeaderIdFunction, BiFunction<JobID, UUID, Boolean> isValidTimeoutFunction) {
        this.startConsumer = startConsumer;
        this.stopRunnable = stopRunnable;
        this.clearRunnable = clearRunnable;
        this.addJobConsumer = addJobConsumer;
        this.removeJobConsumer = removeJobConsumer;
        this.containsJobFunction = containsJobFunction;
        this.getLeaderIdFunction = getLeaderIdFunction;
        this.isValidTimeoutFunction = isValidTimeoutFunction;
    }

    public void start(JobLeaderIdActions initialJobLeaderIdActions) throws Exception {
        this.startConsumer.accept(initialJobLeaderIdActions);
    }

    public void stop() throws Exception {
        this.stopRunnable.run();
    }

    public void clear() throws Exception {
        this.clearRunnable.run();
    }

    public void addJob(JobID jobId) {
        this.addJobConsumer.accept(jobId);
    }

    public void removeJob(JobID jobId) {
        this.removeJobConsumer.accept(jobId);
    }

    public boolean containsJob(JobID jobId) {
        return this.containsJobFunction.apply(jobId);
    }

    public CompletableFuture<JobMasterId> getLeaderId(JobID jobId) throws Exception {
        return this.getLeaderIdFunction.apply(jobId);
    }

    public boolean isValidTimeout(JobID jobId, UUID timeoutId) {
        return this.isValidTimeoutFunction.apply(jobId, timeoutId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Consumer<JobLeaderIdActions> startConsumer = ignored -> {};
        private Runnable stopRunnable = () -> {};
        private Runnable clearRunnable = () -> {};
        private Consumer<JobID> addJobConsumer = ignored -> {};
        private Consumer<JobID> removeJobConsumer = ignored -> {};
        private Function<JobID, Boolean> containsJobFunction = ignored -> false;
        private Function<JobID, CompletableFuture<JobMasterId>> getLeaderIdFunction = ignored -> new CompletableFuture();
        private BiFunction<JobID, UUID, Boolean> isValidTimeoutFunction = (ignoredA, ignoredB) -> false;

        public Builder setStartConsumer(Consumer<JobLeaderIdActions> startConsumer) {
            this.startConsumer = startConsumer;
            return this;
        }

        public Builder setStopRunnable(Runnable stopRunnable) {
            this.stopRunnable = stopRunnable;
            return this;
        }

        public Builder setClearRunnable(Runnable clearRunnable) {
            this.clearRunnable = clearRunnable;
            return this;
        }

        public Builder setAddJobConsumer(Consumer<JobID> addJobConsumer) {
            this.addJobConsumer = addJobConsumer;
            return this;
        }

        public Builder setRemoveJobConsumer(Consumer<JobID> removeJobConsumer) {
            this.removeJobConsumer = removeJobConsumer;
            return this;
        }

        public Builder setContainsJobFunction(Function<JobID, Boolean> containsJobFunction) {
            this.containsJobFunction = containsJobFunction;
            return this;
        }

        public Builder setGetLeaderIdFunction(Function<JobID, CompletableFuture<JobMasterId>> getLeaderIdFunction) {
            this.getLeaderIdFunction = getLeaderIdFunction;
            return this;
        }

        public Builder setIsValidTimeoutFunction(BiFunction<JobID, UUID, Boolean> isValidTimeoutFunction) {
            this.isValidTimeoutFunction = isValidTimeoutFunction;
            return this;
        }

        public TestingJobLeaderIdService build() {
            return new TestingJobLeaderIdService(this.startConsumer, this.stopRunnable, this.clearRunnable, this.addJobConsumer, this.removeJobConsumer, this.containsJobFunction, this.getLeaderIdFunction, this.isValidTimeoutFunction);
        }
    }
}

