/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.slotmanager.LeastUtilizationSlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingTaskManagerSlotInformation;
import org.apache.flink.shaded.guava31.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class LeastUtilizationSlotMatchingStrategyTest {
    LeastUtilizationSlotMatchingStrategyTest() {
    }

    @Test
    void findMatchingSlot_multipleMatchingSlots_returnsSlotWithLeastUtilization() {
        ResourceProfile requestedResourceProfile = ResourceProfile.fromResources((double)2.0, (int)2);
        TestingTaskManagerSlotInformation leastUtilizedSlot = TestingTaskManagerSlotInformation.newBuilder().setResourceProfile(requestedResourceProfile).build();
        TestingTaskManagerSlotInformation tooSmallSlot = TestingTaskManagerSlotInformation.newBuilder().setResourceProfile(ResourceProfile.fromResources((double)1.0, (int)10)).build();
        TestingTaskManagerSlotInformation alternativeSlot = TestingTaskManagerSlotInformation.newBuilder().setResourceProfile(requestedResourceProfile).build();
        List<TestingTaskManagerSlotInformation> freeSlots = Arrays.asList(tooSmallSlot, leastUtilizedSlot, alternativeSlot);
        ImmutableMap registeredSlotPerTaskExecutor = ImmutableMap.of((Object)leastUtilizedSlot.getInstanceId(), (Object)1, (Object)tooSmallSlot.getInstanceId(), (Object)1, (Object)alternativeSlot.getInstanceId(), (Object)2);
        Optional matchingSlot = LeastUtilizationSlotMatchingStrategy.INSTANCE.findMatchingSlot(requestedResourceProfile, freeSlots, this.createRegisteredSlotsLookupFunction((Map<InstanceID, Integer>)registeredSlotPerTaskExecutor));
        Assertions.assertThat((Optional)matchingSlot).hasValueSatisfying(slot -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)slot.getSlotId()).isEqualTo((Object)leastUtilizedSlot.getSlotId());
        });
    }

    private Function<InstanceID, Integer> createRegisteredSlotsLookupFunction(Map<InstanceID, Integer> registeredSlotPerTaskExecutor) {
        return instanceID -> registeredSlotPerTaskExecutor.getOrDefault(instanceID, 0);
    }
}

