/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.rest.handler.job.metrics.AggregatingMetricsHandlerTestBase;
import org.apache.flink.runtime.rest.handler.job.metrics.AggregatingTaskManagersMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregateTaskManagerMetricsParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class AggregatingTaskManagersMetricsHandlerTest
extends AggregatingMetricsHandlerTestBase<AggregatingTaskManagersMetricsHandler, AggregateTaskManagerMetricsParameters> {
    private static final ResourceID TM_ID_1 = ResourceID.generate();
    private static final ResourceID TM_ID_2 = ResourceID.generate();
    private static final ResourceID TM_ID_3 = ResourceID.generate();

    @Override
    protected Tuple2<String, List<String>> getFilter() {
        return Tuple2.of((Object)"taskmanagers", Arrays.asList(TM_ID_1.toString(), TM_ID_3.toString()));
    }

    @Override
    protected Collection<MetricDump> getMetricDumps() {
        ArrayList<MetricDump> dumps = new ArrayList<MetricDump>(3);
        QueryScopeInfo.TaskManagerQueryScopeInfo tm1 = new QueryScopeInfo.TaskManagerQueryScopeInfo(TM_ID_1.toString(), "abc");
        MetricDump.CounterDump cd1 = new MetricDump.CounterDump((QueryScopeInfo)tm1, "metric1", 1L);
        dumps.add((MetricDump)cd1);
        QueryScopeInfo.TaskManagerQueryScopeInfo tm2 = new QueryScopeInfo.TaskManagerQueryScopeInfo(TM_ID_2.toString(), "abc");
        MetricDump.CounterDump cd2 = new MetricDump.CounterDump((QueryScopeInfo)tm2, "metric1", 3L);
        dumps.add((MetricDump)cd2);
        QueryScopeInfo.TaskManagerQueryScopeInfo tm3 = new QueryScopeInfo.TaskManagerQueryScopeInfo(TM_ID_3.toString(), "abc");
        MetricDump.CounterDump cd3 = new MetricDump.CounterDump((QueryScopeInfo)tm3, "metric2", 5L);
        dumps.add((MetricDump)cd3);
        return dumps;
    }

    @Override
    protected AggregatingTaskManagersMetricsHandler getHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, Executor executor, MetricFetcher fetcher) {
        return new AggregatingTaskManagersMetricsHandler(leaderRetriever, timeout, responseHeaders, executor, fetcher);
    }
}

