/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.util;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.blob.NoOpTransientBlobService;
import org.apache.flink.runtime.blob.TransientBlobService;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.DispatcherRestEndpoint;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.VoidMetricFetcher;
import org.apache.flink.runtime.rest.util.DocumentingRestEndpoint;
import org.apache.flink.runtime.rest.util.NoOpExecutionGraphCache;
import org.apache.flink.runtime.rest.util.NoOpFatalErrorHandler;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.util.ConfigurationException;

public class DocumentingDispatcherRestEndpoint
extends DispatcherRestEndpoint
implements DocumentingRestEndpoint {
    private static final Configuration config = new Configuration();
    private static final RestHandlerConfiguration handlerConfig;
    private static final GatewayRetriever<DispatcherGateway> dispatcherGatewayRetriever;
    private static final GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever;

    public DocumentingDispatcherRestEndpoint() throws IOException, ConfigurationException {
        super(dispatcherGatewayRetriever, config, handlerConfig, resourceManagerGatewayRetriever, (TransientBlobService)NoOpTransientBlobService.INSTANCE, Executors.newScheduledThreadPool(1), (MetricFetcher)VoidMetricFetcher.INSTANCE, (LeaderElection)NoOpLeaderElection.INSTANCE, (ExecutionGraphCache)NoOpExecutionGraphCache.INSTANCE, (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);
    }

    @Override
    public List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> initializeHandlers(CompletableFuture<String> localAddressFuture) {
        return super.initializeHandlers(localAddressFuture);
    }

    static {
        config.setString(RestOptions.ADDRESS, "localhost");
        config.setString(JobManagerOptions.ADDRESS, "localhost");
        handlerConfig = RestHandlerConfiguration.fromConfiguration((Configuration)config);
        dispatcherGatewayRetriever = () -> null;
        resourceManagerGatewayRetriever = () -> null;
    }

    private static enum NoOpLeaderElection implements LeaderElection
    {
        INSTANCE;


        public void startLeaderElection(LeaderContender contender) {
        }

        public void confirmLeadership(UUID leaderSessionID, String leaderAddress) {
        }

        public boolean hasLeadership(UUID leaderSessionId) {
            return false;
        }

        public void close() {
        }
    }
}

