/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rpc.AddressResolution;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.exceptions.RpcConnectionException;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.util.TestLogger;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class RpcConnectionTest
extends TestLogger {
    @Test
    public void testConnectFailure() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set(AkkaOptions.ASK_TIMEOUT_DURATION, (Object)Duration.ofSeconds(10000000L));
        try (RpcSystem rpcSystem = RpcSystem.load();){
            RpcService rpcService = rpcSystem.remoteServiceBuilder(configuration, null, "8000-9000").withBindAddress("localhost").withBindPort(0).createAndStart();
            String invalidAddress = rpcSystem.getRpcUrl(rpcService.getAddress() + ".invalid", rpcService.getPort(), "foo", AddressResolution.NO_ADDRESS_RESOLUTION, new Configuration());
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
                TaskExecutorGateway cfr_ignored_0 = (TaskExecutorGateway)rpcService.connect(invalidAddress, TaskExecutorGateway.class).get(10000000L, TimeUnit.SECONDS);
            }).cause().isInstanceOf(RpcConnectionException.class)).hasMessageContaining(invalidAddress);
            rpcService.closeAsync().get();
        }
    }
}

