/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.DefaultVertexParallelismStore;
import org.apache.flink.runtime.scheduler.VertexParallelismInformation;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class DefaultVertexParallelismStoreTest
extends TestLogger {
    @Test
    public void testNotSet() {
        DefaultVertexParallelismStore store = new DefaultVertexParallelismStore();
        CommonTestUtils.assertThrows((String)"No parallelism information set for vertex", IllegalStateException.class, () -> store.getParallelismInfo(new JobVertexID()));
    }

    @Test
    public void testSetInfo() {
        JobVertexID id = new JobVertexID();
        MockVertexParallelismInfo info = new MockVertexParallelismInfo();
        DefaultVertexParallelismStore store = new DefaultVertexParallelismStore();
        store.setParallelismInfo(id, (VertexParallelismInformation)info);
        VertexParallelismInformation storedInfo = store.getParallelismInfo(id);
        Assert.assertEquals((Object)storedInfo, (Object)storedInfo);
    }

    private static final class MockVertexParallelismInfo
    implements VertexParallelismInformation {
        private MockVertexParallelismInfo() {
        }

        public int getMinParallelism() {
            return 0;
        }

        public int getParallelism() {
            return 0;
        }

        public int getMaxParallelism() {
            return 0;
        }

        public void setParallelism(int parallelism) {
        }

        public void setMaxParallelism(int maxParallelism) {
        }

        public boolean canRescaleMaxParallelism(int desiredMaxParallelism) {
            return false;
        }
    }
}

