/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.local.LocalDataOutputStream;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.core.fs.local.LocalRecoverableFsDataOutputStream;
import org.apache.flink.core.fs.local.LocalRecoverableWriter;
import org.apache.flink.runtime.state.filesystem.FsCheckpointMetadataOutputStream;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.FunctionWithException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FsCheckpointMetadataOutputStreamTest
extends TestLogger {
    @Parameterized.Parameter
    public FileSystem fileSystem;
    @Rule
    public final TemporaryFolder tempDir = new TemporaryFolder();

    @Parameterized.Parameters(name="{0}")
    public static Collection<FileSystem> getFileSystems() {
        return Arrays.asList(new FileSystem[]{new FsWithRecoverableWriter(), new FsWithoutRecoverableWriter()});
    }

    @Test
    public void testFileExistence() throws Exception {
        Path metaDataFilePath = this.baseFolder();
        FsCheckpointMetadataOutputStream stream = this.createTestStream(metaDataFilePath, this.fileSystem);
        if (this.fileSystem instanceof FsWithoutRecoverableWriter) {
            Assert.assertTrue((boolean)this.fileSystem.exists(metaDataFilePath));
        } else {
            Assert.assertFalse((boolean)this.fileSystem.exists(metaDataFilePath));
        }
        stream.closeAndFinalizeCheckpoint();
        Assert.assertTrue((boolean)this.fileSystem.exists(metaDataFilePath));
    }

    @Test
    public void testCleanupWhenClosed() throws Exception {
        Path metaDataFilePath = this.baseFolder();
        FsCheckpointMetadataOutputStream stream = this.createTestStream(metaDataFilePath, this.fileSystem);
        stream.close();
        Assert.assertFalse((boolean)this.fileSystem.exists(metaDataFilePath));
    }

    @Test
    public void testCleanupWhenCommitFailed() throws Exception {
        Path metaDataFilePath = this.baseFolder();
        this.fileSystem = this.fileSystem instanceof FsWithoutRecoverableWriter ? ((FsWithoutRecoverableWriter)this.fileSystem).withStreamFactory((FunctionWithException<Path, FSDataOutputStream, IOException>)path -> new FailingCloseStream(new File(path.getPath()))) : ((FsWithRecoverableWriter)this.fileSystem).withStreamFactory((BiFunctionWithException<Path, Path, LocalRecoverableFsDataOutputStream, IOException>)(path, temp) -> new FailingRecoverableFsStream(new File(path.getPath()), new File(temp.getPath())));
        FsCheckpointMetadataOutputStream stream = this.createTestStream(metaDataFilePath, this.fileSystem);
        try {
            stream.closeAndFinalizeCheckpoint();
            Assert.fail((String)"Exception expected when committing the meta file.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.fileSystem.exists(metaDataFilePath));
        if (this.fileSystem instanceof FsWithoutRecoverableWriter) {
            ((FsWithoutRecoverableWriter)this.fileSystem).resetStreamFactory();
        } else {
            ((FsWithRecoverableWriter)this.fileSystem).resetStreamFactory();
        }
    }

    private FsCheckpointMetadataOutputStream createTestStream(Path metaDataFilePath, FileSystem fileSystem) throws IOException {
        FsCheckpointMetadataOutputStream stream = new FsCheckpointMetadataOutputStream(fileSystem, metaDataFilePath, new Path("fooBarName"));
        for (int i = 0; i < 100; ++i) {
            stream.write(66);
        }
        return stream;
    }

    private Path baseFolder() throws Exception {
        return new Path(new File(this.tempDir.newFolder(), UUID.randomUUID().toString()).toURI());
    }

    private static class FailingCloseStream
    extends LocalDataOutputStream {
        FailingCloseStream(File file) throws IOException {
            super(file);
        }

        public void close() throws IOException {
            throw new IOException();
        }
    }

    private static class FailingRecoverableFsStream
    extends LocalRecoverableFsDataOutputStream {
        public FailingRecoverableFsStream(File targetFile, File tempFile) throws IOException {
            super(targetFile, tempFile);
        }

        public void close() throws IOException {
            throw new IOException();
        }
    }

    private static class FsLocalRecoverableWriter
    extends LocalRecoverableWriter {
        private final BiFunctionWithException<Path, Path, LocalRecoverableFsDataOutputStream, IOException> streamFactory;
        private final LocalFileSystem fs;

        public FsLocalRecoverableWriter(LocalFileSystem fs, BiFunctionWithException<Path, Path, LocalRecoverableFsDataOutputStream, IOException> streamFactory) {
            super(fs);
            this.fs = fs;
            this.streamFactory = streamFactory;
        }

        public RecoverableFsDataOutputStream open(Path filePath) throws IOException {
            File temp = FsLocalRecoverableWriter.generateStagingTempFilePath((File)this.fs.pathToFile(filePath));
            return (RecoverableFsDataOutputStream)this.streamFactory.apply((Object)filePath, (Object)new Path(temp.getPath()));
        }
    }

    private static class FsWithRecoverableWriter
    extends LocalFileSystem {
        private BiFunctionWithException<Path, Path, LocalRecoverableFsDataOutputStream, IOException> streamFactory;

        private FsWithRecoverableWriter() {
        }

        private FsWithRecoverableWriter withStreamFactory(BiFunctionWithException<Path, Path, LocalRecoverableFsDataOutputStream, IOException> streamFactory) {
            this.streamFactory = streamFactory;
            return this;
        }

        private void resetStreamFactory() {
            this.streamFactory = null;
        }

        public LocalRecoverableWriter createRecoverableWriter() throws IOException {
            if (this.streamFactory == null) {
                return super.createRecoverableWriter();
            }
            return new FsLocalRecoverableWriter(this, this.streamFactory);
        }

        public String toString() {
            return "FileSystem with RecoverableWriter";
        }
    }

    private static class FsWithoutRecoverableWriter
    extends LocalFileSystem {
        private FunctionWithException<Path, FSDataOutputStream, IOException> streamFactory;

        private FsWithoutRecoverableWriter() {
        }

        private FileSystem withStreamFactory(FunctionWithException<Path, FSDataOutputStream, IOException> streamFactory) {
            this.streamFactory = streamFactory;
            return this;
        }

        private void resetStreamFactory() {
            this.streamFactory = null;
        }

        public FSDataOutputStream create(Path filePath, FileSystem.WriteMode overwrite) throws IOException {
            if (this.streamFactory == null) {
                return super.create(filePath, overwrite);
            }
            return (FSDataOutputStream)this.streamFactory.apply((Object)filePath);
        }

        public LocalRecoverableWriter createRecoverableWriter() throws IOException {
            throw new UnsupportedOperationException("This file system does not support recoverable writers.");
        }

        public String toString() {
            return "FileSystem without RecoverableWriter";
        }
    }
}

