/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.buffer.BufferDecompressor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolFactory;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.metrics.InputChannelMetrics;
import org.apache.flink.runtime.io.network.partition.PartitionProducerStateProvider;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.consumer.GateBuffersSpec;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputGateSpecUtils;
import org.apache.flink.runtime.io.network.partition.consumer.LocalRecoveredInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteRecoveredInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.UnknownInputChannel;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageConfiguration;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TieredStorageNettyServiceImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageConsumerClient;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageConsumerSpec;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.shuffle.NettyShuffleUtils;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleIOOwnerContext;
import org.apache.flink.runtime.shuffle.ShuffleUtils;
import org.apache.flink.runtime.taskmanager.NettyShuffleEnvironmentConfiguration;
import org.apache.flink.runtime.throughput.BufferDebloatConfiguration;
import org.apache.flink.runtime.throughput.BufferDebloater;
import org.apache.flink.runtime.throughput.ThroughputCalculator;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.apache.flink.util.function.SupplierWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleInputGateFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SingleInputGateFactory.class);
    @Nonnull
    protected final ResourceID taskExecutorResourceId;
    protected final int partitionRequestInitialBackoff;
    protected final int partitionRequestMaxBackoff;
    @Nonnull
    protected final ConnectionManager connectionManager;
    @Nonnull
    protected final ResultPartitionManager partitionManager;
    @Nonnull
    protected final TaskEventPublisher taskEventPublisher;
    @Nonnull
    protected final NetworkBufferPool networkBufferPool;
    private final Optional<Integer> maxRequiredBuffersPerGate;
    protected final int configuredNetworkBuffersPerChannel;
    private final int floatingNetworkBuffersPerGate;
    private final boolean batchShuffleCompressionEnabled;
    private final String compressionCodec;
    private final int networkBufferSize;
    private final BufferDebloatConfiguration debloatConfiguration;
    @Nullable
    private final TieredStorageConfiguration tieredStorageConfiguration;
    @Nullable
    private final TieredStorageNettyServiceImpl tieredStorageNettyService;

    public SingleInputGateFactory(@Nonnull ResourceID taskExecutorResourceId, @Nonnull NettyShuffleEnvironmentConfiguration networkConfig, @Nonnull ConnectionManager connectionManager, @Nonnull ResultPartitionManager partitionManager, @Nonnull TaskEventPublisher taskEventPublisher, @Nonnull NetworkBufferPool networkBufferPool, @Nullable TieredStorageConfiguration tieredStorageConfiguration, @Nullable TieredStorageNettyServiceImpl tieredStorageNettyService) {
        this.taskExecutorResourceId = taskExecutorResourceId;
        this.partitionRequestInitialBackoff = networkConfig.partitionRequestInitialBackoff();
        this.partitionRequestMaxBackoff = networkConfig.partitionRequestMaxBackoff();
        this.maxRequiredBuffersPerGate = networkConfig.maxRequiredBuffersPerGate();
        this.configuredNetworkBuffersPerChannel = NettyShuffleUtils.getNetworkBuffersPerInputChannel(networkConfig.networkBuffersPerChannel());
        this.floatingNetworkBuffersPerGate = networkConfig.floatingNetworkBuffersPerGate();
        this.batchShuffleCompressionEnabled = networkConfig.isBatchShuffleCompressionEnabled();
        this.compressionCodec = networkConfig.getCompressionCodec();
        this.networkBufferSize = networkConfig.networkBufferSize();
        this.connectionManager = connectionManager;
        this.partitionManager = partitionManager;
        this.taskEventPublisher = taskEventPublisher;
        this.networkBufferPool = networkBufferPool;
        this.debloatConfiguration = networkConfig.getDebloatConfiguration();
        this.tieredStorageConfiguration = tieredStorageConfiguration;
        this.tieredStorageNettyService = tieredStorageNettyService;
    }

    public SingleInputGate create(@Nonnull ShuffleIOOwnerContext owner, int gateIndex, @Nonnull InputGateDeploymentDescriptor igdd, @Nonnull PartitionProducerStateProvider partitionProducerStateProvider, @Nonnull InputChannelMetrics metrics) {
        GateBuffersSpec gateBuffersSpec = InputGateSpecUtils.createGateBuffersSpec(this.maxRequiredBuffersPerGate, this.configuredNetworkBuffersPerChannel, this.floatingNetworkBuffersPerGate, igdd.getConsumedPartitionType(), SingleInputGateFactory.calculateNumChannels(igdd.getShuffleDescriptors().length, igdd.getConsumedSubpartitionIndexRange()), this.tieredStorageConfiguration != null);
        SupplierWithException<BufferPool, IOException> bufferPoolFactory = SingleInputGateFactory.createBufferPoolFactory(this.networkBufferPool, gateBuffersSpec.getRequiredFloatingBuffers(), gateBuffersSpec.getTotalFloatingBuffers());
        BufferDecompressor bufferDecompressor = null;
        if (igdd.getConsumedPartitionType().supportCompression() && this.batchShuffleCompressionEnabled) {
            bufferDecompressor = new BufferDecompressor(this.networkBufferSize, this.compressionCodec);
        }
        String owningTaskName = owner.getOwnerName();
        MetricGroup networkInputGroup = owner.getInputGroup();
        IndexRange subpartitionIndexRange = igdd.getConsumedSubpartitionIndexRange();
        TieredStorageConsumerClient tieredStorageConsumerClient = null;
        ArrayList<TieredStorageConsumerSpec> tieredStorageConsumerSpecs = null;
        if (this.tieredStorageConfiguration != null) {
            ShuffleDescriptor[] shuffleDescriptors = igdd.getShuffleDescriptors();
            tieredStorageConsumerSpecs = new ArrayList<TieredStorageConsumerSpec>();
            for (ShuffleDescriptor shuffleDescriptor : shuffleDescriptors) {
                TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId(shuffleDescriptor.getResultPartitionID());
                for (int index = subpartitionIndexRange.getStartIndex(); index <= subpartitionIndexRange.getEndIndex(); ++index) {
                    TieredStorageSubpartitionId subpartitionId = new TieredStorageSubpartitionId(index);
                    tieredStorageConsumerSpecs.add(new TieredStorageConsumerSpec(partitionId, subpartitionId));
                }
            }
            tieredStorageConsumerClient = new TieredStorageConsumerClient(this.tieredStorageConfiguration.getTierFactories(), tieredStorageConsumerSpecs, this.tieredStorageNettyService);
        }
        SingleInputGate inputGate = new SingleInputGate(owningTaskName, gateIndex, igdd.getConsumedResultId(), igdd.getConsumedPartitionType(), subpartitionIndexRange, SingleInputGateFactory.calculateNumChannels(igdd.getShuffleDescriptors().length, subpartitionIndexRange), partitionProducerStateProvider, bufferPoolFactory, bufferDecompressor, this.networkBufferPool, this.networkBufferSize, new ThroughputCalculator((Clock)SystemClock.getInstance()), this.maybeCreateBufferDebloater(owningTaskName, gateIndex, networkInputGroup.addGroup(gateIndex)), tieredStorageConsumerClient, this.tieredStorageNettyService, tieredStorageConsumerSpecs);
        this.createInputChannels(owningTaskName, igdd, inputGate, subpartitionIndexRange, gateBuffersSpec, metrics);
        return inputGate;
    }

    private BufferDebloater maybeCreateBufferDebloater(String owningTaskName, int gateIndex, MetricGroup inputGroup) {
        if (this.debloatConfiguration.isEnabled()) {
            BufferDebloater bufferDebloater = new BufferDebloater(owningTaskName, gateIndex, this.debloatConfiguration.getTargetTotalBufferSize().toMillis(), this.debloatConfiguration.getMaxBufferSize(), this.debloatConfiguration.getMinBufferSize(), this.debloatConfiguration.getBufferDebloatThresholdPercentages(), this.debloatConfiguration.getNumberOfSamples());
            inputGroup.gauge("estimatedTimeToConsumeBuffersMs", () -> bufferDebloater.getLastEstimatedTimeToConsumeBuffers().toMillis());
            inputGroup.gauge("debloatedBufferSize", bufferDebloater::getLastBufferSize);
            return bufferDebloater;
        }
        return null;
    }

    private void createInputChannels(String owningTaskName, InputGateDeploymentDescriptor inputGateDeploymentDescriptor, SingleInputGate inputGate, IndexRange subpartitionIndexRange, GateBuffersSpec gateBuffersSpec, InputChannelMetrics metrics) {
        ShuffleDescriptor[] shuffleDescriptors = inputGateDeploymentDescriptor.getShuffleDescriptors();
        InputChannel[] inputChannels = new InputChannel[SingleInputGateFactory.calculateNumChannels(shuffleDescriptors.length, subpartitionIndexRange)];
        ChannelStatistics channelStatistics = new ChannelStatistics();
        int channelIdx = 0;
        for (int i = 0; i < shuffleDescriptors.length; ++i) {
            for (int subpartitionIndex = subpartitionIndexRange.getStartIndex(); subpartitionIndex <= subpartitionIndexRange.getEndIndex(); ++subpartitionIndex) {
                inputChannels[channelIdx] = this.createInputChannel(inputGate, channelIdx, gateBuffersSpec.getEffectiveExclusiveBuffersPerChannel(), shuffleDescriptors[i], subpartitionIndex, channelStatistics, metrics);
                ++channelIdx;
            }
        }
        inputGate.setInputChannels(inputChannels);
        LOG.debug("{}: Created {} input channels ({}).", new Object[]{owningTaskName, inputChannels.length, channelStatistics});
    }

    private InputChannel createInputChannel(SingleInputGate inputGate, int index, int buffersPerChannel, ShuffleDescriptor shuffleDescriptor, int consumedSubpartitionIndex, ChannelStatistics channelStatistics, InputChannelMetrics metrics) {
        return ShuffleUtils.applyWithShuffleTypeCheck(NettyShuffleDescriptor.class, shuffleDescriptor, unknownShuffleDescriptor -> {
            ++channelStatistics.numUnknownChannels;
            return new UnknownInputChannel(inputGate, index, unknownShuffleDescriptor.getResultPartitionID(), consumedSubpartitionIndex, this.partitionManager, this.taskEventPublisher, this.connectionManager, this.partitionRequestInitialBackoff, this.partitionRequestMaxBackoff, buffersPerChannel, metrics);
        }, nettyShuffleDescriptor -> this.createKnownInputChannel(inputGate, index, buffersPerChannel, (NettyShuffleDescriptor)nettyShuffleDescriptor, consumedSubpartitionIndex, channelStatistics, metrics));
    }

    private static int calculateNumChannels(int numShuffleDescriptors, IndexRange subpartitionIndexRange) {
        return MathUtils.checkedDownCast((long)((long)numShuffleDescriptors * (long)subpartitionIndexRange.size()));
    }

    @VisibleForTesting
    protected InputChannel createKnownInputChannel(SingleInputGate inputGate, int index, int buffersPerChannel, NettyShuffleDescriptor inputChannelDescriptor, int consumedSubpartitionIndex, ChannelStatistics channelStatistics, InputChannelMetrics metrics) {
        ResultPartitionID partitionId = inputChannelDescriptor.getResultPartitionID();
        if (inputChannelDescriptor.isLocalTo(this.taskExecutorResourceId)) {
            ++channelStatistics.numLocalChannels;
            return new LocalRecoveredInputChannel(inputGate, index, partitionId, consumedSubpartitionIndex, this.partitionManager, this.taskEventPublisher, this.partitionRequestInitialBackoff, this.partitionRequestMaxBackoff, buffersPerChannel, metrics);
        }
        ++channelStatistics.numRemoteChannels;
        return new RemoteRecoveredInputChannel(inputGate, index, partitionId, consumedSubpartitionIndex, inputChannelDescriptor.getConnectionId(), this.connectionManager, this.partitionRequestInitialBackoff, this.partitionRequestMaxBackoff, buffersPerChannel, metrics);
    }

    @VisibleForTesting
    static SupplierWithException<BufferPool, IOException> createBufferPoolFactory(BufferPoolFactory bufferPoolFactory, int minFloatingBuffersPerGate, int maxFloatingBuffersPerGate) {
        Pair pair = Pair.of((Object)minFloatingBuffersPerGate, (Object)maxFloatingBuffersPerGate);
        return () -> bufferPoolFactory.createBufferPool((Integer)pair.getLeft(), (Integer)pair.getRight());
    }

    protected static class ChannelStatistics {
        int numLocalChannels;
        int numRemoteChannels;
        int numUnknownChannels;

        protected ChannelStatistics() {
        }

        public String toString() {
            return String.format("local: %s, remote: %s, unknown: %s", this.numLocalChannels, this.numRemoteChannels, this.numUnknownChannels);
        }
    }
}

