/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.disk;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import net.jcip.annotations.GuardedBy;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.util.Preconditions;

class SubpartitionDiskCacheManager {
    private final Deque<Tuple2<Buffer, Integer>> allBuffers = new LinkedList<Tuple2<Buffer, Integer>>();
    @GuardedBy(value="allBuffers")
    private int segmentId;
    private int bufferIndex;

    SubpartitionDiskCacheManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startSegment(int segmentId) {
        Deque<Tuple2<Buffer, Integer>> deque = this.allBuffers;
        synchronized (deque) {
            this.segmentId = segmentId;
        }
    }

    void append(Buffer buffer) {
        this.addBuffer(buffer);
    }

    void appendEndOfSegmentEvent(ByteBuffer record) {
        this.writeEvent(record, Buffer.DataType.END_OF_SEGMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Tuple2<Buffer, Integer>> removeAllBuffers() {
        Deque<Tuple2<Buffer, Integer>> deque = this.allBuffers;
        synchronized (deque) {
            ArrayList<Tuple2<Buffer, Integer>> targetBuffers = new ArrayList<Tuple2<Buffer, Integer>>(this.allBuffers);
            this.allBuffers.clear();
            return targetBuffers;
        }
    }

    int getBufferIndex() {
        return this.bufferIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getSegmentId() {
        Deque<Tuple2<Buffer, Integer>> deque = this.allBuffers;
        synchronized (deque) {
            return this.segmentId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        Deque<Tuple2<Buffer, Integer>> deque = this.allBuffers;
        synchronized (deque) {
            Preconditions.checkState((boolean)this.allBuffers.isEmpty(), (Object)"Leaking buffers.");
        }
    }

    private void writeEvent(ByteBuffer event, Buffer.DataType dataType) {
        Preconditions.checkArgument((boolean)dataType.isEvent());
        MemorySegment data = MemorySegmentFactory.wrap((byte[])event.array());
        this.addBuffer(new NetworkBuffer(data, FreeingBufferRecycler.INSTANCE, dataType, data.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBuffer(Buffer buffer) {
        Deque<Tuple2<Buffer, Integer>> deque = this.allBuffers;
        synchronized (deque) {
            this.allBuffers.add((Tuple2<Buffer, Integer>)new Tuple2((Object)buffer, (Object)this.bufferIndex));
        }
        ++this.bufferIndex;
    }
}

