/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateFactory;
import org.apache.flink.runtime.scheduler.adaptive.StateTransitions;
import org.slf4j.Logger;

class Created
implements State {
    private final Context context;
    private final Logger logger;

    Created(Context context, Logger logger) {
        this.context = context;
        this.logger = logger;
    }

    @Override
    public void cancel() {
        this.context.goToFinished(this.context.getArchivedExecutionGraph(JobStatus.CANCELED, null));
    }

    @Override
    public void suspend(Throwable cause) {
        this.context.goToFinished(this.context.getArchivedExecutionGraph(JobStatus.SUSPENDED, cause));
    }

    @Override
    public JobStatus getJobStatus() {
        return JobStatus.INITIALIZING;
    }

    @Override
    public ArchivedExecutionGraph getJob() {
        return this.context.getArchivedExecutionGraph(this.getJobStatus(), null);
    }

    @Override
    public void handleGlobalFailure(Throwable cause, CompletableFuture<Map<String, String>> failureLabels) {
        this.context.goToFinished(this.context.getArchivedExecutionGraph(JobStatus.FAILED, cause));
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    void startScheduling() {
        this.context.goToWaitingForResources(null);
    }

    static class Factory
    implements StateFactory<Created> {
        private final Context context;
        private final Logger log;

        public Factory(Context context, Logger log) {
            this.context = context;
            this.log = log;
        }

        @Override
        public Class<Created> getStateClass() {
            return Created.class;
        }

        @Override
        public Created getState() {
            return new Created(this.context, this.log);
        }
    }

    static interface Context
    extends StateTransitions.ToFinished,
    StateTransitions.ToWaitingForResources {
        public ArchivedExecutionGraph getArchivedExecutionGraph(JobStatus var1, @Nullable Throwable var2);
    }
}

