/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint.component;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.entrypoint.component.JobGraphRetriever;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.function.FunctionUtils;

public abstract class AbstractUserClassPathJobGraphRetriever
implements JobGraphRetriever {
    @Nonnull
    private final Collection<URL> userClassPaths;

    protected AbstractUserClassPathJobGraphRetriever(@Nullable File jobDir) throws IOException {
        if (jobDir == null) {
            this.userClassPaths = Collections.emptyList();
        } else {
            Path workingDirectory = FileUtils.getCurrentWorkingDirectory();
            Collection relativeJarURLs = FileUtils.listFilesInDirectory((Path)jobDir.toPath(), FileUtils::isJarFile).stream().map(path -> FileUtils.relativizePath((Path)workingDirectory, (Path)path)).map(FunctionUtils.uncheckedFunction(FileUtils::toURL)).collect(Collectors.toList());
            this.userClassPaths = Collections.unmodifiableCollection(relativeJarURLs);
        }
    }

    protected Collection<URL> getUserClassPaths() {
        return this.userClassPaths;
    }
}

