/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayDeque;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartitionView;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipelinedSubpartition
extends ResultSubpartition {
    private static final Logger LOG = LoggerFactory.getLogger(PipelinedSubpartition.class);
    private final ArrayDeque<BufferConsumer> buffers = new ArrayDeque();
    @GuardedBy(value="buffers")
    private int buffersInBacklog;
    private PipelinedSubpartitionView readView;
    private boolean isFinished;
    @GuardedBy(value="buffers")
    private boolean flushRequested;
    private volatile boolean isReleased;
    private long totalNumberOfBuffers;
    private long totalNumberOfBytes;

    PipelinedSubpartition(int index, ResultPartition parent) {
        super(index, parent);
    }

    @Override
    public boolean add(BufferConsumer bufferConsumer) {
        return this.add(bufferConsumer, false);
    }

    @Override
    public void finish() throws IOException {
        this.add(EventSerializer.toBufferConsumer(EndOfPartitionEvent.INSTANCE), true);
        LOG.debug("{}: Finished {}.", (Object)this.parent.getOwningTaskName(), (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(BufferConsumer bufferConsumer, boolean finish) {
        boolean notifyDataAvailable;
        Preconditions.checkNotNull((Object)bufferConsumer);
        ArrayDeque<BufferConsumer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.isFinished || this.isReleased) {
                bufferConsumer.close();
                return false;
            }
            this.buffers.add(bufferConsumer);
            this.updateStatistics(bufferConsumer);
            this.increaseBuffersInBacklog(bufferConsumer);
            notifyDataAvailable = this.shouldNotifyDataAvailable() || finish;
            this.isFinished |= finish;
        }
        if (notifyDataAvailable) {
            this.notifyDataAvailable();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        PipelinedSubpartitionView view;
        ArrayDeque<BufferConsumer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.isReleased) {
                return;
            }
            for (BufferConsumer buffer : this.buffers) {
                buffer.close();
            }
            this.buffers.clear();
            view = this.readView;
            this.readView = null;
            this.isReleased = true;
        }
        LOG.debug("{}: Released {}.", (Object)this.parent.getOwningTaskName(), (Object)this);
        if (view != null) {
            view.releaseAllResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ResultSubpartition.BufferAndBacklog pollBuffer() {
        ArrayDeque<BufferConsumer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            Buffer buffer = null;
            if (this.buffers.isEmpty()) {
                this.flushRequested = false;
            }
            while (!this.buffers.isEmpty()) {
                BufferConsumer bufferConsumer = this.buffers.peek();
                buffer = bufferConsumer.build();
                Preconditions.checkState((bufferConsumer.isFinished() || this.buffers.size() == 1 ? 1 : 0) != 0, (Object)"When there are multiple buffers, an unfinished bufferConsumer can not be at the head of the buffers queue.");
                if (this.buffers.size() == 1) {
                    this.flushRequested = false;
                }
                if (bufferConsumer.isFinished()) {
                    this.buffers.pop().close();
                    this.decreaseBuffersInBacklogUnsafe(bufferConsumer.isBuffer());
                }
                if (buffer.readableBytes() > 0) break;
                buffer.recycleBuffer();
                buffer = null;
                if (bufferConsumer.isFinished()) continue;
                break;
            }
            if (buffer == null) {
                return null;
            }
            this.updateStatistics(buffer);
            return new ResultSubpartition.BufferAndBacklog(buffer, this.isAvailableUnsafe(), this.getBuffersInBacklog(), this.nextBufferIsEventUnsafe());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean nextBufferIsEvent() {
        ArrayDeque<BufferConsumer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            return this.nextBufferIsEventUnsafe();
        }
    }

    private boolean nextBufferIsEventUnsafe() {
        assert (Thread.holdsLock(this.buffers));
        return !this.buffers.isEmpty() && !this.buffers.peekFirst().isBuffer();
    }

    @Override
    public int releaseMemory() {
        return 0;
    }

    @Override
    public boolean isReleased() {
        return this.isReleased;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PipelinedSubpartitionView createReadView(BufferAvailabilityListener availabilityListener) throws IOException {
        boolean notifyDataAvailable;
        ArrayDeque<BufferConsumer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            Preconditions.checkState((!this.isReleased ? 1 : 0) != 0);
            Preconditions.checkState((this.readView == null ? 1 : 0) != 0, (String)"Subpartition %s of is being (or already has been) consumed, but pipelined subpartitions can only be consumed once.", (Object[])new Object[]{this.index, this.parent.getPartitionId()});
            LOG.debug("{}: Creating read view for subpartition {} of partition {}.", new Object[]{this.parent.getOwningTaskName(), this.index, this.parent.getPartitionId()});
            this.readView = new PipelinedSubpartitionView(this, availabilityListener);
            notifyDataAvailable = !this.buffers.isEmpty();
        }
        if (notifyDataAvailable) {
            this.notifyDataAvailable();
        }
        return this.readView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable() {
        ArrayDeque<BufferConsumer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            return this.isAvailableUnsafe();
        }
    }

    private boolean isAvailableUnsafe() {
        return this.flushRequested || this.getNumberOfFinishedBuffers() > 0;
    }

    int getCurrentNumberOfBuffers() {
        return this.buffers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean hasReadView;
        boolean finished;
        long numBytes;
        long numBuffers;
        ArrayDeque<BufferConsumer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            numBuffers = this.getTotalNumberOfBuffers();
            numBytes = this.getTotalNumberOfBytes();
            finished = this.isFinished;
            hasReadView = this.readView != null;
        }
        return String.format("PipelinedSubpartition#%d [number of buffers: %d (%d bytes), number of buffers in backlog: %d, finished? %s, read view? %s]", this.index, numBuffers, numBytes, this.getBuffersInBacklog(), finished, hasReadView);
    }

    @Override
    public int unsynchronizedGetNumberOfQueuedBuffers() {
        return Math.max(this.buffers.size(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        boolean notifyDataAvailable;
        ArrayDeque<BufferConsumer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.buffers.isEmpty()) {
                return;
            }
            notifyDataAvailable = !this.flushRequested && this.buffers.size() == 1 && this.buffers.peek().isDataAvailable();
            this.flushRequested = this.flushRequested || this.buffers.size() > 1 || notifyDataAvailable;
        }
        if (notifyDataAvailable) {
            this.notifyDataAvailable();
        }
    }

    @Override
    protected long getTotalNumberOfBuffers() {
        return this.totalNumberOfBuffers;
    }

    @Override
    protected long getTotalNumberOfBytes() {
        return this.totalNumberOfBytes;
    }

    Throwable getFailureCause() {
        return this.parent.getFailureCause();
    }

    private void updateStatistics(BufferConsumer buffer) {
        ++this.totalNumberOfBuffers;
    }

    private void updateStatistics(Buffer buffer) {
        this.totalNumberOfBytes += (long)buffer.getSize();
    }

    @GuardedBy(value="buffers")
    private void decreaseBuffersInBacklogUnsafe(boolean isBuffer) {
        assert (Thread.holdsLock(this.buffers));
        if (isBuffer) {
            --this.buffersInBacklog;
        }
    }

    @GuardedBy(value="buffers")
    private void increaseBuffersInBacklog(BufferConsumer buffer) {
        assert (Thread.holdsLock(this.buffers));
        if (buffer != null && buffer.isBuffer()) {
            ++this.buffersInBacklog;
        }
    }

    @Override
    @VisibleForTesting
    public int getBuffersInBacklog() {
        if (this.flushRequested || this.isFinished) {
            return this.buffersInBacklog;
        }
        return Math.max(this.buffersInBacklog - 1, 0);
    }

    private boolean shouldNotifyDataAvailable() {
        return this.readView != null && !this.flushRequested && this.getNumberOfFinishedBuffers() == 1;
    }

    private void notifyDataAvailable() {
        if (this.readView != null) {
            this.readView.notifyDataAvailable();
        }
    }

    private int getNumberOfFinishedBuffers() {
        assert (Thread.holdsLock(this.buffers));
        if (this.buffers.size() == 1 && this.buffers.peekLast().isFinished()) {
            return 1;
        }
        return Math.max(0, this.buffers.size() - 1);
    }
}

