/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.exceptions.ResourceManagerException;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.Preconditions;

public class StandaloneResourceManager
extends ResourceManager<ResourceID> {
    private final Time startupPeriodTime;

    public StandaloneResourceManager(RpcService rpcService, String resourceManagerEndpointId, ResourceID resourceId, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, SlotManager slotManager, JobLeaderIdService jobLeaderIdService, ClusterInformation clusterInformation, FatalErrorHandler fatalErrorHandler, ResourceManagerMetricGroup resourceManagerMetricGroup, Time startupPeriodTime) {
        super(rpcService, resourceManagerEndpointId, resourceId, highAvailabilityServices, heartbeatServices, slotManager, jobLeaderIdService, clusterInformation, fatalErrorHandler, resourceManagerMetricGroup);
        this.startupPeriodTime = (Time)Preconditions.checkNotNull((Object)startupPeriodTime);
    }

    @Override
    protected void initialize() throws ResourceManagerException {
    }

    @Override
    protected void internalDeregisterApplication(ApplicationStatus finalStatus, @Nullable String diagnostics) {
    }

    @Override
    public Collection<ResourceProfile> startNewWorker(ResourceProfile resourceProfile) {
        return Collections.emptyList();
    }

    @Override
    public boolean stopWorker(ResourceID resourceID) {
        return false;
    }

    @Override
    protected ResourceID workerStarted(ResourceID resourceID) {
        return resourceID;
    }

    @Override
    protected void startServicesOnLeadership() {
        super.startServicesOnLeadership();
        this.startStartupPeriod();
    }

    private void startStartupPeriod() {
        this.setFailUnfulfillableRequest(false);
        long startupPeriodMillis = this.startupPeriodTime.toMilliseconds();
        if (startupPeriodMillis > 0L) {
            this.scheduleRunAsync(() -> this.setFailUnfulfillableRequest(true), startupPeriodMillis, TimeUnit.MILLISECONDS);
        }
    }
}

