/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.flink.api.common.InputDependencyConstraint;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverVertex;
import org.apache.flink.runtime.scheduler.adapter.DefaultResultPartition;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.util.Preconditions;

class DefaultExecutionVertex
implements SchedulingExecutionVertex<DefaultExecutionVertex, DefaultResultPartition>,
FailoverVertex<DefaultExecutionVertex, DefaultResultPartition> {
    private final ExecutionVertexID executionVertexId;
    private final List<DefaultResultPartition> consumedResults;
    private final List<DefaultResultPartition> producedResults;
    private final Supplier<ExecutionState> stateSupplier;
    private final InputDependencyConstraint inputDependencyConstraint;

    DefaultExecutionVertex(ExecutionVertexID executionVertexId, List<DefaultResultPartition> producedPartitions, Supplier<ExecutionState> stateSupplier, InputDependencyConstraint constraint) {
        this.executionVertexId = (ExecutionVertexID)Preconditions.checkNotNull((Object)executionVertexId);
        this.consumedResults = new ArrayList<DefaultResultPartition>();
        this.stateSupplier = (Supplier)Preconditions.checkNotNull(stateSupplier);
        this.producedResults = (List)Preconditions.checkNotNull(producedPartitions);
        this.inputDependencyConstraint = (InputDependencyConstraint)Preconditions.checkNotNull((Object)constraint);
    }

    @Override
    public ExecutionVertexID getId() {
        return this.executionVertexId;
    }

    @Override
    public ExecutionState getState() {
        return this.stateSupplier.get();
    }

    @Override
    public Iterable<DefaultResultPartition> getConsumedResults() {
        return this.consumedResults;
    }

    @Override
    public Iterable<DefaultResultPartition> getProducedResults() {
        return this.producedResults;
    }

    @Override
    public InputDependencyConstraint getInputDependencyConstraint() {
        return this.inputDependencyConstraint;
    }

    void addConsumedResult(DefaultResultPartition result) {
        this.consumedResults.add(result);
    }
}

