/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import java.time.Duration;
import org.apache.flink.runtime.executiongraph.restart.FixedDelayRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;

public class NoOrFixedIfCheckpointingEnabledRestartStrategyFactory
extends RestartStrategyFactory {
    private static final long serialVersionUID = -1809462525812787862L;
    public static final int DEFAULT_RESTART_ATTEMPTS = Integer.MAX_VALUE;
    public static final long DEFAULT_RESTART_DELAY = Duration.ofSeconds(1L).toMillis();

    @Override
    public RestartStrategy createRestartStrategy() {
        return this.createRestartStrategy(false);
    }

    RestartStrategy createRestartStrategy(boolean isCheckpointingEnabled) {
        if (isCheckpointingEnabled) {
            return new FixedDelayRestartStrategy(Integer.MAX_VALUE, DEFAULT_RESTART_DELAY);
        }
        return new NoRestartStrategy();
    }
}

