/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.runtime.checkpoint.OperatorStateRepartitioner;
import org.apache.flink.shaded.guava18.com.google.common.collect.Iterables;
import org.apache.flink.util.Preconditions;

@NotThreadSafe
public class MappingBasedRepartitioner<T>
implements OperatorStateRepartitioner<T> {
    private final Map<Integer, Set<Integer>> newToOldSubtasksMapping;

    public MappingBasedRepartitioner(Map<Integer, Set<Integer>> newToOldSubtasksMapping) {
        this.newToOldSubtasksMapping = newToOldSubtasksMapping;
    }

    private static <T> List<T> extractOldState(List<List<T>> previousParallelSubtaskStates, Set<Integer> oldIndexes) {
        switch (oldIndexes.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return previousParallelSubtaskStates.get((Integer)Iterables.getOnlyElement(oldIndexes));
            }
        }
        return oldIndexes.stream().flatMap(oldIndex -> ((List)previousParallelSubtaskStates.get((int)oldIndex)).stream()).collect(Collectors.toList());
    }

    @Override
    public List<List<T>> repartitionState(List<List<T>> previousParallelSubtaskStates, int oldParallelism, int newParallelism) {
        Preconditions.checkState((newParallelism == this.newToOldSubtasksMapping.size() ? 1 : 0) != 0);
        ArrayList<List<T>> repartitioned = new ArrayList<List<T>>();
        for (int newIndex = 0; newIndex < newParallelism; ++newIndex) {
            repartitioned.add(MappingBasedRepartitioner.extractOldState(previousParallelSubtaskStates, this.newToOldSubtasksMapping.get(newIndex)));
        }
        return repartitioned;
    }
}

