/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.runtime.executiongraph.failover.flip1.StronglyConnectedComponentsComputeUtils;
import org.apache.flink.runtime.topology.Result;
import org.apache.flink.runtime.topology.Vertex;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelinedRegionComputeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PipelinedRegionComputeUtil.class);

    public static <V extends Vertex<?, ?, V, R>, R extends Result<?, ?, V, R>> Set<Set<V>> computePipelinedRegions(Iterable<? extends V> topologicallySortedVertexes) {
        Map<? extends V, Set<? extends V>> vertexToRegion = PipelinedRegionComputeUtil.buildRawRegions(topologicallySortedVertexes);
        return PipelinedRegionComputeUtil.mergeRegionsOnCycles(vertexToRegion);
    }

    private static <V extends Vertex<?, ?, V, R>, R extends Result<?, ?, V, R>> Map<V, Set<V>> buildRawRegions(Iterable<? extends V> topologicallySortedVertexes) {
        IdentityHashMap vertexToRegion = new IdentityHashMap();
        for (Vertex vertex : topologicallySortedVertexes) {
            Set currentRegion = new HashSet<Vertex>();
            currentRegion.add(vertex);
            vertexToRegion.put(vertex, currentRegion);
            for (Result consumedResult : vertex.getConsumedResults()) {
                if (consumedResult.getResultType().isReconnectable()) continue;
                Object producerVertex = consumedResult.getProducer();
                Set producerRegion = (Set)vertexToRegion.get(producerVertex);
                if (producerRegion == null) {
                    throw new IllegalStateException("Producer task " + producerVertex.getId() + " failover region is null while calculating failover region for the consumer task " + vertex.getId() + ". This should be a failover region building bug.");
                }
                if (currentRegion == producerRegion) continue;
                currentRegion = PipelinedRegionComputeUtil.mergeRegions(currentRegion, producerRegion, vertexToRegion);
            }
        }
        return vertexToRegion;
    }

    private static <V extends Vertex<?, ?, V, ?>> Set<V> mergeRegions(Set<V> region1, Set<V> region2, Map<V, Set<V>> vertexToRegion) {
        Set<V> largerSet;
        Set<V> smallerSet;
        if (region1.size() < region2.size()) {
            smallerSet = region1;
            largerSet = region2;
        } else {
            smallerSet = region2;
            largerSet = region1;
        }
        for (Vertex v : smallerSet) {
            vertexToRegion.put((Set<V>)((Object)v), (Set<Set<V>>)largerSet);
        }
        largerSet.addAll(smallerSet);
        return largerSet;
    }

    private static <V extends Vertex<?, ?, V, ?>> Set<Set<V>> uniqueRegions(Map<V, Set<V>> vertexToRegion) {
        Set<Set<V>> distinctRegions = Collections.newSetFromMap(new IdentityHashMap());
        distinctRegions.addAll(vertexToRegion.values());
        return distinctRegions;
    }

    private static <V extends Vertex<?, ?, V, R>, R extends Result<?, ?, V, R>> Set<Set<V>> mergeRegionsOnCycles(Map<V, Set<V>> vertexToRegion) {
        List<Set<V>> regionList = PipelinedRegionComputeUtil.uniqueRegions(vertexToRegion).stream().collect(Collectors.toList());
        List<List<Integer>> outEdges = PipelinedRegionComputeUtil.buildOutEdgesDesc(vertexToRegion, regionList);
        Set<Set<Integer>> sccs = StronglyConnectedComponentsComputeUtils.computeStronglyConnectedComponents(outEdges.size(), outEdges);
        Set<Set<V>> mergedRegions = Collections.newSetFromMap(new IdentityHashMap());
        for (Set<Integer> scc : sccs) {
            Preconditions.checkState((scc.size() > 0 ? 1 : 0) != 0);
            Set mergedRegion = new HashSet();
            for (int regionIndex : scc) {
                mergedRegion = PipelinedRegionComputeUtil.mergeRegions(mergedRegion, regionList.get(regionIndex), vertexToRegion);
            }
            mergedRegions.add(mergedRegion);
        }
        return mergedRegions;
    }

    private static <V extends Vertex<?, ?, V, R>, R extends Result<?, ?, V, R>> List<List<Integer>> buildOutEdgesDesc(Map<V, Set<V>> vertexToRegion, List<Set<V>> regionList) {
        IdentityHashMap<Set<V>, Integer> regionIndices = new IdentityHashMap<Set<V>, Integer>();
        for (int i = 0; i < regionList.size(); ++i) {
            regionIndices.put(regionList.get(i), i);
        }
        ArrayList<List<Integer>> outEdges = new ArrayList<List<Integer>>(regionList.size());
        for (int i = 0; i < regionList.size(); ++i) {
            ArrayList currentRegionOutEdges = new ArrayList();
            Set<V> currentRegion = regionList.get(i);
            for (Vertex vertex : currentRegion) {
                for (Result producedResult : vertex.getProducedResults()) {
                    if (producedResult.getResultType().isPipelined()) continue;
                    for (Vertex consumerVertex : producedResult.getConsumers()) {
                        if (currentRegion.contains(consumerVertex)) continue;
                        currentRegionOutEdges.add(regionIndices.get(vertexToRegion.get(consumerVertex)));
                    }
                }
            }
            outEdges.add(currentRegionOutEdges);
        }
        return outEdges;
    }

    private PipelinedRegionComputeUtil() {
    }
}

