/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.ReadRequest;

final class SegmentReadRequest
implements ReadRequest {
    private final AsynchronousFileIOChannel<MemorySegment, ReadRequest> channel;
    private final MemorySegment segment;

    protected SegmentReadRequest(AsynchronousFileIOChannel<MemorySegment, ReadRequest> targetChannel, MemorySegment segment) {
        if (segment == null) {
            throw new NullPointerException("Illegal read request with null memory segment.");
        }
        this.channel = targetChannel;
        this.segment = segment;
    }

    @Override
    public void read() throws IOException {
        FileChannel c = this.channel.fileChannel;
        if (c.size() - c.position() > 0L) {
            try {
                ByteBuffer wrapper = this.segment.wrap(0, this.segment.size());
                this.channel.fileChannel.read(wrapper);
            }
            catch (NullPointerException npex) {
                throw new IOException("Memory segment has been released.");
            }
        }
    }

    @Override
    public void requestDone(IOException ioex) {
        this.channel.handleProcessedBuffer(this.segment, ioex);
    }
}

