/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.registration;

import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TaskExecutorMemoryConfiguration;
import org.apache.flink.util.Preconditions;

public class WorkerRegistration<WorkerType extends ResourceIDRetrievable>
extends TaskExecutorConnection {
    private final WorkerType worker;
    private final int dataPort;
    private final int jmxPort;
    private final HardwareDescription hardwareDescription;
    private final TaskExecutorMemoryConfiguration memoryConfiguration;

    public WorkerRegistration(TaskExecutorGateway taskExecutorGateway, WorkerType worker, int dataPort, int jmxPort, HardwareDescription hardwareDescription, TaskExecutorMemoryConfiguration memoryConfiguration) {
        super(worker.getResourceID(), taskExecutorGateway);
        this.worker = (ResourceIDRetrievable)Preconditions.checkNotNull(worker);
        this.dataPort = dataPort;
        this.jmxPort = jmxPort;
        this.hardwareDescription = (HardwareDescription)Preconditions.checkNotNull((Object)hardwareDescription);
        this.memoryConfiguration = (TaskExecutorMemoryConfiguration)Preconditions.checkNotNull((Object)memoryConfiguration);
    }

    public WorkerType getWorker() {
        return this.worker;
    }

    public int getDataPort() {
        return this.dataPort;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public HardwareDescription getHardwareDescription() {
        return this.hardwareDescription;
    }

    public TaskExecutorMemoryConfiguration getMemoryConfiguration() {
        return this.memoryConfiguration;
    }
}

