/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.slots.ResourceCounter;
import org.apache.flink.util.Preconditions;

class BiDirectionalResourceToRequirementMapping {
    private final Map<ResourceProfile, ResourceCounter> requirementToFulfillingResources = new HashMap<ResourceProfile, ResourceCounter>();
    private final Map<ResourceProfile, ResourceCounter> resourceToFulfilledRequirement = new HashMap<ResourceProfile, ResourceCounter>();

    BiDirectionalResourceToRequirementMapping() {
    }

    public void incrementCount(ResourceProfile requirement, ResourceProfile resource, int increment) {
        Preconditions.checkNotNull((Object)requirement);
        Preconditions.checkNotNull((Object)resource);
        Preconditions.checkArgument((increment > 0 ? 1 : 0) != 0);
        BiDirectionalResourceToRequirementMapping.internalIncrementCount(this.requirementToFulfillingResources, requirement, resource, increment);
        BiDirectionalResourceToRequirementMapping.internalIncrementCount(this.resourceToFulfilledRequirement, resource, requirement, increment);
    }

    public void decrementCount(ResourceProfile requirement, ResourceProfile resource, int decrement) {
        Preconditions.checkNotNull((Object)requirement);
        Preconditions.checkNotNull((Object)resource);
        Preconditions.checkArgument((decrement > 0 ? 1 : 0) != 0);
        BiDirectionalResourceToRequirementMapping.internalDecrementCount(this.requirementToFulfillingResources, requirement, resource, decrement);
        BiDirectionalResourceToRequirementMapping.internalDecrementCount(this.resourceToFulfilledRequirement, resource, requirement, decrement);
    }

    private static void internalIncrementCount(Map<ResourceProfile, ResourceCounter> primaryMap, ResourceProfile primaryKey, ResourceProfile secondaryKey, int increment) {
        primaryMap.computeIfAbsent(primaryKey, ignored -> new ResourceCounter()).incrementCount(secondaryKey, increment);
    }

    private static void internalDecrementCount(Map<ResourceProfile, ResourceCounter> primaryMap, ResourceProfile primaryKey, ResourceProfile secondaryKey, int decrement) {
        primaryMap.compute(primaryKey, (resourceProfile, resourceCounter) -> {
            Preconditions.checkState((resourceCounter != null ? 1 : 0) != 0, (String)"Attempting to decrement count of %s->%s, but primary key was unknown.", (Object[])new Object[]{resourceProfile, secondaryKey});
            resourceCounter.decrementCount(secondaryKey, decrement);
            return resourceCounter.isEmpty() ? null : resourceCounter;
        });
    }

    public Map<ResourceProfile, Integer> getResourcesFulfilling(ResourceProfile requirement) {
        Preconditions.checkNotNull((Object)requirement);
        return this.requirementToFulfillingResources.getOrDefault(requirement, ResourceCounter.EMPTY).getResourceProfilesWithCount();
    }

    public Map<ResourceProfile, Integer> getRequirementsFulfilledBy(ResourceProfile resource) {
        Preconditions.checkNotNull((Object)resource);
        return this.resourceToFulfilledRequirement.getOrDefault(resource, ResourceCounter.EMPTY).getResourceProfilesWithCount();
    }

    public Set<ResourceProfile> getAllResourceProfiles() {
        return this.resourceToFulfilledRequirement.keySet();
    }

    public Set<ResourceProfile> getAllRequirementProfiles() {
        return this.requirementToFulfillingResources.keySet();
    }

    public int getNumFulfillingResources(ResourceProfile requirement) {
        Preconditions.checkNotNull((Object)requirement);
        return this.requirementToFulfillingResources.getOrDefault(requirement, ResourceCounter.EMPTY).getResourceCount();
    }

    public int getNumFulfilledRequirements(ResourceProfile resource) {
        Preconditions.checkNotNull((Object)resource);
        return this.resourceToFulfilledRequirement.getOrDefault(resource, ResourceCounter.EMPTY).getResourceCount();
    }

    @VisibleForTesting
    boolean isEmpty() {
        return this.requirementToFulfillingResources.isEmpty() && this.resourceToFulfilledRequirement.isEmpty();
    }
}

