/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.instance.SlotSharingGroupAssignment;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public class SharedSlot
extends Slot
implements LogicalSlot {
    private final SlotSharingGroupAssignment assignmentGroup;
    private final Set<Slot> subSlots;

    public SharedSlot(SlotOwner owner, TaskManagerLocation location, int slotNumber, TaskManagerGateway taskManagerGateway, SlotSharingGroupAssignment assignmentGroup) {
        this(owner, location, slotNumber, taskManagerGateway, assignmentGroup, null, null);
    }

    public SharedSlot(SlotOwner owner, TaskManagerLocation location, int slotNumber, TaskManagerGateway taskManagerGateway, SlotSharingGroupAssignment assignmentGroup, @Nullable SharedSlot parent, @Nullable AbstractID groupId) {
        super(owner, location, slotNumber, taskManagerGateway, parent, groupId);
        this.assignmentGroup = (SlotSharingGroupAssignment)Preconditions.checkNotNull((Object)assignmentGroup);
        this.subSlots = new HashSet<Slot>();
    }

    public SharedSlot(SlotContext slotContext, SlotOwner owner, SlotSharingGroupAssignment assignmentGroup) {
        this(slotContext, owner, slotContext.getPhysicalSlotNumber(), assignmentGroup, null, null);
    }

    private SharedSlot(SlotContext slotInformation, SlotOwner owner, int slotNumber, SlotSharingGroupAssignment assignmentGroup, @Nullable SharedSlot parent, @Nullable AbstractID groupId) {
        super(slotInformation, owner, slotNumber, parent, groupId);
        this.assignmentGroup = (SlotSharingGroupAssignment)Preconditions.checkNotNull((Object)assignmentGroup);
        this.subSlots = new HashSet<Slot>();
    }

    @Override
    public int getNumberLeaves() {
        while (true) {
            try {
                int result = 0;
                for (Slot slot : this.subSlots) {
                    result += slot.getNumberLeaves();
                }
                return result;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    public boolean isRootAndEmpty() {
        return this.getParent() == null && this.subSlots.isEmpty();
    }

    public boolean hasChildren() {
        return this.subSlots.size() > 0;
    }

    @Override
    public Locality getLocality() {
        return Locality.UNKNOWN;
    }

    @Override
    public boolean tryAssignPayload(LogicalSlot.Payload payload) {
        throw new UnsupportedOperationException("Cannot assign an execution attempt id to a shared slot.");
    }

    @Override
    @Nullable
    public LogicalSlot.Payload getPayload() {
        return null;
    }

    @Override
    public CompletableFuture<?> releaseSlot(@Nullable Throwable cause) {
        this.assignmentGroup.releaseSharedSlot(this);
        if (!this.isReleased() || !this.subSlots.isEmpty()) {
            throw new IllegalStateException("Bug: SharedSlot is not empty and released after call to releaseSlot()");
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public int getPhysicalSlotNumber() {
        return this.getRootSlotNumber();
    }

    @Override
    public AllocationID getAllocationId() {
        return this.getSlotContext().getAllocationId();
    }

    @Override
    public SlotRequestId getSlotRequestId() {
        return NO_SLOT_REQUEST_ID;
    }

    @Override
    @Nullable
    public SlotSharingGroupId getSlotSharingGroupId() {
        return NO_SLOT_SHARING_GROUP_ID;
    }

    Set<Slot> getSubSlots() {
        return this.subSlots;
    }

    SimpleSlot allocateSubSlot(AbstractID groupId) {
        if (this.isAlive()) {
            SimpleSlot slot = new SimpleSlot(this.getOwner(), this.getTaskManagerLocation(), this.subSlots.size(), this.getTaskManagerGateway(), this, groupId);
            this.subSlots.add(slot);
            return slot;
        }
        return null;
    }

    SharedSlot allocateSharedSlot(AbstractID groupId) {
        if (this.isAlive()) {
            SharedSlot slot = new SharedSlot(this.getOwner(), this.getTaskManagerLocation(), this.subSlots.size(), this.getTaskManagerGateway(), this.assignmentGroup, this, groupId);
            this.subSlots.add(slot);
            return slot;
        }
        return null;
    }

    void releaseChild(SimpleSlot slot) {
        this.assignmentGroup.releaseSimpleSlot(slot);
    }

    int removeDisposedChildSlot(Slot slot) {
        if (!slot.isReleased() || !this.subSlots.remove(slot)) {
            throw new IllegalArgumentException();
        }
        return this.subSlots.size();
    }

    @Override
    public String toString() {
        return "Shared " + super.toString();
    }
}

