/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public class CoLocationConstraint {
    private final CoLocationGroup group;
    private volatile SharedSlot sharedSlot;
    private volatile TaskManagerLocation lockedLocation;
    private volatile SlotRequestId slotRequestId;

    CoLocationConstraint(CoLocationGroup group) {
        Preconditions.checkNotNull((Object)group);
        this.group = group;
        this.slotRequestId = null;
    }

    public SharedSlot getSharedSlot() {
        return this.sharedSlot;
    }

    public AbstractID getGroupId() {
        return this.group.getId();
    }

    public boolean isAssigned() {
        return this.lockedLocation != null;
    }

    public boolean isAssignedAndAlive() {
        return this.lockedLocation != null && this.sharedSlot.isAlive();
    }

    public TaskManagerLocation getLocation() {
        if (this.lockedLocation != null) {
            return this.lockedLocation;
        }
        throw new IllegalStateException("Location not yet locked");
    }

    public void setSharedSlot(SharedSlot newSlot) {
        Preconditions.checkNotNull((Object)newSlot);
        if (this.sharedSlot == null) {
            this.sharedSlot = newSlot;
        } else if (newSlot != this.sharedSlot) {
            if (this.lockedLocation != null && !Objects.equals(this.lockedLocation, newSlot.getTaskManagerLocation())) {
                throw new IllegalArgumentException("Cannot assign different location to a constraint whose location is locked.");
            }
            if (this.sharedSlot.isAlive()) {
                this.sharedSlot.releaseSlot(new FlinkException("Setting new shared slot for co-location constraint."));
            }
            this.sharedSlot = newSlot;
        }
    }

    public void lockLocation() throws IllegalStateException {
        Preconditions.checkState((this.lockedLocation == null ? 1 : 0) != 0, (Object)"Location is already locked");
        Preconditions.checkState((this.sharedSlot != null ? 1 : 0) != 0, (Object)"Cannot lock location without a slot.");
        this.lockedLocation = this.sharedSlot.getTaskManagerLocation();
    }

    public void lockLocation(TaskManagerLocation taskManagerLocation) {
        Preconditions.checkNotNull((Object)taskManagerLocation);
        Preconditions.checkState((this.lockedLocation == null ? 1 : 0) != 0, (Object)"Location is already locked.");
        this.lockedLocation = taskManagerLocation;
    }

    public void setSlotRequestId(@Nullable SlotRequestId slotRequestId) {
        this.slotRequestId = slotRequestId;
    }

    @Nullable
    public SlotRequestId getSlotRequestId() {
        return this.slotRequestId;
    }

    public String toString() {
        return "CoLocation constraint id " + this.getGroupId() + " shared slot " + this.sharedSlot;
    }
}

