/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.net;

import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class SSLEngineFactory {
    private final SSLContext sslContext;
    private final String[] enabledProtocols;
    private final String[] enabledCipherSuites;
    private final boolean clientMode;

    public SSLEngineFactory(SSLContext sslContext, String[] enabledProtocols, String[] enabledCipherSuites, boolean clientMode) {
        this.sslContext = Objects.requireNonNull(sslContext, "sslContext must not be null");
        this.enabledProtocols = Objects.requireNonNull(enabledProtocols, "enabledProtocols must not be null");
        this.enabledCipherSuites = Objects.requireNonNull(enabledCipherSuites, "cipherSuites must not be null");
        this.clientMode = clientMode;
    }

    public SSLEngine createSSLEngine() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        sslEngine.setEnabledProtocols(this.enabledProtocols);
        sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        sslEngine.setUseClientMode(this.clientMode);
        return sslEngine;
    }
}

