/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.net;

import java.io.File;
import java.io.FileInputStream;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManagerFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.net.SSLEngineFactory;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SSLUtils.class);

    public static boolean getSSLEnabled(Configuration sslConfig) {
        Preconditions.checkNotNull((Object)sslConfig);
        return sslConfig.getBoolean(SecurityOptions.SSL_ENABLED);
    }

    public static void setSSLVerAndCipherSuites(ServerSocket socket, Configuration config) {
        if (socket instanceof SSLServerSocket) {
            Object[] protocols = config.getString(SecurityOptions.SSL_PROTOCOL).split(",");
            Object[] cipherSuites = config.getString(SecurityOptions.SSL_ALGORITHMS).split(",");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Configuring TLS version and cipher suites on SSL socket {} / {}", (Object)Arrays.toString(protocols), (Object)Arrays.toString(cipherSuites));
            }
            ((SSLServerSocket)socket).setEnabledProtocols((String[])protocols);
            ((SSLServerSocket)socket).setEnabledCipherSuites((String[])cipherSuites);
        }
    }

    public static SSLEngineFactory createServerSSLEngineFactory(Configuration config) throws Exception {
        return SSLUtils.createSSLEngineFactory(config, false);
    }

    public static SSLEngineFactory createClientSSLEngineFactory(Configuration config) throws Exception {
        return SSLUtils.createSSLEngineFactory(config, true);
    }

    private static SSLEngineFactory createSSLEngineFactory(Configuration config, boolean clientMode) throws Exception {
        SSLContext sslContext = clientMode ? SSLUtils.createSSLClientContext(config) : SSLUtils.createSSLServerContext(config);
        Preconditions.checkState((sslContext != null ? 1 : 0) != 0, (String)"%s it not enabled", (Object[])new Object[]{SecurityOptions.SSL_ENABLED.key()});
        return new SSLEngineFactory(sslContext, SSLUtils.getEnabledProtocols(config), SSLUtils.getEnabledCipherSuites(config), clientMode);
    }

    @Deprecated
    public static void setSSLVerAndCipherSuites(SSLEngine engine, Configuration config) {
        engine.setEnabledProtocols(SSLUtils.getEnabledProtocols(config));
        engine.setEnabledCipherSuites(SSLUtils.getEnabledCipherSuites(config));
    }

    private static String[] getEnabledProtocols(Configuration config) {
        Objects.requireNonNull(config, "config must not be null");
        return config.getString(SecurityOptions.SSL_PROTOCOL).split(",");
    }

    private static String[] getEnabledCipherSuites(Configuration config) {
        Objects.requireNonNull(config, "config must not be null");
        return config.getString(SecurityOptions.SSL_ALGORITHMS).split(",");
    }

    public static void setSSLVerifyHostname(Configuration sslConfig, SSLParameters sslParams) {
        Preconditions.checkNotNull((Object)sslConfig);
        Preconditions.checkNotNull((Object)sslParams);
        boolean verifyHostname = sslConfig.getBoolean(SecurityOptions.SSL_VERIFY_HOSTNAME);
        if (verifyHostname) {
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static SSLContext createSSLClientContext(Configuration sslConfig) throws Exception {
        Preconditions.checkNotNull((Object)sslConfig);
        SSLContext clientSSLContext = null;
        if (SSLUtils.getSSLEnabled(sslConfig)) {
            LOG.debug("Creating client SSL context from configuration");
            String trustStoreFilePath = sslConfig.getString(SecurityOptions.SSL_TRUSTSTORE);
            String trustStorePassword = sslConfig.getString(SecurityOptions.SSL_TRUSTSTORE_PASSWORD);
            String sslProtocolVersion = sslConfig.getString(SecurityOptions.SSL_PROTOCOL);
            Preconditions.checkNotNull((Object)trustStoreFilePath, (String)(SecurityOptions.SSL_TRUSTSTORE.key() + " was not configured."));
            Preconditions.checkNotNull((Object)trustStorePassword, (String)(SecurityOptions.SSL_TRUSTSTORE_PASSWORD.key() + " was not configured."));
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream trustStoreFile = null;){
                trustStoreFile = new FileInputStream(new File(trustStoreFilePath));
                trustStore.load(trustStoreFile, trustStorePassword.toCharArray());
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            clientSSLContext = SSLContext.getInstance(sslProtocolVersion);
            clientSSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
        }
        return clientSSLContext;
    }

    @Nullable
    public static SSLContext createSSLServerContext(Configuration sslConfig) throws Exception {
        Preconditions.checkNotNull((Object)sslConfig);
        SSLContext serverSSLContext = null;
        if (SSLUtils.getSSLEnabled(sslConfig)) {
            LOG.debug("Creating server SSL context from configuration");
            String keystoreFilePath = sslConfig.getString(SecurityOptions.SSL_KEYSTORE);
            String keystorePassword = sslConfig.getString(SecurityOptions.SSL_KEYSTORE_PASSWORD);
            String certPassword = sslConfig.getString(SecurityOptions.SSL_KEY_PASSWORD);
            String sslProtocolVersion = sslConfig.getString(SecurityOptions.SSL_PROTOCOL);
            Preconditions.checkNotNull((Object)keystoreFilePath, (String)(SecurityOptions.SSL_KEYSTORE.key() + " was not configured."));
            Preconditions.checkNotNull((Object)keystorePassword, (String)(SecurityOptions.SSL_KEYSTORE_PASSWORD.key() + " was not configured."));
            Preconditions.checkNotNull((Object)certPassword, (String)(SecurityOptions.SSL_KEY_PASSWORD.key() + " was not configured."));
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream keyStoreFile = new FileInputStream(new File(keystoreFilePath));){
                ks.load(keyStoreFile, keystorePassword.toCharArray());
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, certPassword.toCharArray());
            serverSSLContext = SSLContext.getInstance(sslProtocolVersion);
            serverSSLContext.init(kmf.getKeyManagers(), null, null);
        }
        return serverSSLContext;
    }
}

