/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.UUID;
import org.apache.flink.runtime.rest.RestServerEndpoint;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpObject;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.LastHttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.DiskFileUpload;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.HttpDataFactory;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import org.apache.flink.shaded.netty4.io.netty.util.AttributeKey;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger LOG = LoggerFactory.getLogger(FileUploadHandler.class);
    static final AttributeKey<Path> UPLOADED_FILE = AttributeKey.valueOf((String)"UPLOADED_FILE");
    private static final HttpDataFactory DATA_FACTORY = new DefaultHttpDataFactory(true);
    private final Path uploadDir;
    private HttpPostRequestDecoder currentHttpPostRequestDecoder;
    private HttpRequest currentHttpRequest;

    public FileUploadHandler(Path uploadDir) {
        super(false);
        DiskFileUpload.baseDirectory = uploadDir.normalize().toAbsolutePath().toString();
        this.uploadDir = Objects.requireNonNull(uploadDir);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            if (httpRequest.getMethod().equals((Object)HttpMethod.POST)) {
                if (HttpPostRequestDecoder.isMultipart((HttpRequest)httpRequest)) {
                    this.currentHttpPostRequestDecoder = new HttpPostRequestDecoder(DATA_FACTORY, httpRequest);
                    this.currentHttpRequest = httpRequest;
                } else {
                    ctx.fireChannelRead((Object)msg);
                }
            } else {
                ctx.fireChannelRead((Object)msg);
            }
        } else if (msg instanceof HttpContent && this.currentHttpPostRequestDecoder != null) {
            RestServerEndpoint.createUploadDir(this.uploadDir, LOG);
            HttpContent httpContent = (HttpContent)msg;
            this.currentHttpPostRequestDecoder.offer(httpContent);
            while (this.currentHttpPostRequestDecoder.hasNext()) {
                InterfaceHttpData data = this.currentHttpPostRequestDecoder.next();
                if (data.getHttpDataType() == InterfaceHttpData.HttpDataType.FileUpload) {
                    DiskFileUpload fileUpload = (DiskFileUpload)data;
                    Preconditions.checkState((boolean)fileUpload.isCompleted());
                    Path dest = this.uploadDir.resolve(Paths.get(UUID.randomUUID() + "_" + fileUpload.getFilename(), new String[0]));
                    fileUpload.renameTo(dest.toFile());
                    ctx.channel().attr(UPLOADED_FILE).set((Object)dest);
                }
                data.release();
            }
            if (httpContent instanceof LastHttpContent) {
                ctx.fireChannelRead((Object)this.currentHttpRequest);
                ctx.fireChannelRead((Object)httpContent);
                this.reset();
            }
        } else {
            ctx.fireChannelRead((Object)msg);
        }
    }

    private void reset() {
        this.currentHttpPostRequestDecoder.destroy();
        this.currentHttpPostRequestDecoder = null;
        this.currentHttpRequest = null;
    }
}

