/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.rest.AbstractHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

@ChannelHandler.Sharable
public abstract class AbstractRestHandler<T extends RestfulGateway, R extends RequestBody, P extends ResponseBody, M extends MessageParameters>
extends AbstractHandler<T, R, M> {
    private final MessageHeaders<R, P, M> messageHeaders;

    protected AbstractRestHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends T> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<R, P, M> messageHeaders) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.messageHeaders = (MessageHeaders)Preconditions.checkNotNull(messageHeaders);
    }

    public MessageHeaders<R, P, M> getMessageHeaders() {
        return this.messageHeaders;
    }

    @Override
    protected void respondToRequest(ChannelHandlerContext ctx, HttpRequest httpRequest, HandlerRequest<R, M> handlerRequest, T gateway) throws RestHandlerException {
        CompletableFuture<Object> response;
        try {
            response = this.handleRequest(handlerRequest, gateway);
        }
        catch (RestHandlerException e) {
            response = FutureUtils.completedExceptionally((Throwable)((Object)e));
        }
        response.whenComplete((resp, throwable) -> {
            if (throwable != null) {
                Throwable error = ExceptionUtils.stripCompletionException((Throwable)throwable);
                if (error instanceof RestHandlerException) {
                    RestHandlerException rhe = (RestHandlerException)((Object)((Object)error));
                    this.log.error("Exception occurred in REST handler.", error);
                    HandlerUtils.sendErrorResponse(ctx, httpRequest, new ErrorResponseBody(rhe.getMessage()), rhe.getHttpResponseStatus(), (Map<String, String>)this.responseHeaders);
                } else {
                    this.log.error("Implementation error: Unhandled exception.", error);
                    HandlerUtils.sendErrorResponse(ctx, httpRequest, new ErrorResponseBody("Internal server error."), HttpResponseStatus.INTERNAL_SERVER_ERROR, (Map<String, String>)this.responseHeaders);
                }
            } else {
                HandlerUtils.sendResponse(ctx, httpRequest, resp, this.messageHeaders.getResponseStatusCode(), (Map<String, String>)this.responseHeaders);
            }
        });
    }

    protected abstract CompletableFuture<P> handleRequest(@Nonnull HandlerRequest<R, M> var1, @Nonnull T var2) throws RestHandlerException;
}

