/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.legacy.AbstractExecutionGraphRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;

public class JobConfigHandler
extends AbstractExecutionGraphRequestHandler {
    private static final String JOB_CONFIG_REST_PATH = "/jobs/:jobid/config";

    public JobConfigHandler(ExecutionGraphCache executionGraphCache, Executor executor) {
        super(executionGraphCache, executor);
    }

    @Override
    public String[] getPaths() {
        return new String[]{JOB_CONFIG_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleRequest(AccessExecutionGraph graph, Map<String, String> params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return JobConfigHandler.createJobConfigJson(graph);
            }
            catch (IOException e) {
                throw new CompletionException(new FlinkException("Could not write job config json.", (Throwable)e));
            }
        }, this.executor);
    }

    public static String createJobConfigJson(AccessExecutionGraph graph) throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        gen.writeStartObject();
        gen.writeStringField("jid", graph.getJobID().toString());
        gen.writeStringField("name", graph.getJobName());
        ArchivedExecutionConfig summary = graph.getArchivedExecutionConfig();
        if (summary != null) {
            gen.writeObjectFieldStart("execution-config");
            gen.writeStringField("execution-mode", summary.getExecutionMode());
            gen.writeStringField("restart-strategy", summary.getRestartStrategyDescription());
            gen.writeNumberField("job-parallelism", summary.getParallelism());
            gen.writeBooleanField("object-reuse-mode", summary.getObjectReuseEnabled());
            Map ucVals = summary.getGlobalJobParameters();
            if (ucVals != null) {
                gen.writeObjectFieldStart("user-config");
                for (Map.Entry ucVal : ucVals.entrySet()) {
                    gen.writeStringField((String)ucVal.getKey(), (String)ucVal.getValue());
                }
                gen.writeEndObject();
            }
            gen.writeEndObject();
        }
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }

    public static class JobConfigJsonArchivist
    implements JsonArchivist {
        @Override
        public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
            String json = JobConfigHandler.createJobConfigJson(graph);
            String path = JobConfigHandler.JOB_CONFIG_REST_PATH.replace(":jobid", graph.getJobID().toString());
            return Collections.singletonList(new ArchivedJson(path, json));
        }
    }
}

