/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJsonRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.rest.handler.legacy.metrics.DoubleAccumulator;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAggregatingMetricsHandler
extends AbstractJsonRequestHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String PARAMETER_AGGREGATION = "agg";
    private final MetricFetcher fetcher;

    AbstractAggregatingMetricsHandler(Executor executor, MetricFetcher fetcher) {
        super(executor);
        this.fetcher = (MetricFetcher)Preconditions.checkNotNull((Object)fetcher);
    }

    protected abstract Collection<? extends MetricStore.ComponentMetricStore> getStores(MetricStore var1, Map<String, String> var2, Map<String, String> var3);

    @Override
    public CompletableFuture<String> handleJsonRequest(Map<String, String> pathParams, Map<String, String> queryParams, JobManagerGateway jobManagerGateway) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.fetcher.update();
                String requestedMetricsList = (String)queryParams.get("get");
                String aggTypeList = (String)queryParams.get(PARAMETER_AGGREGATION);
                MetricStore store = this.fetcher.getMetricStore();
                Collection<? extends MetricStore.ComponentMetricStore> stores = this.getStores(store, pathParams, queryParams);
                if (stores == null) {
                    return "[]";
                }
                if (requestedMetricsList == null) {
                    Collection<String> list = AbstractAggregatingMetricsHandler.getAvailableMetrics(stores);
                    return AbstractAggregatingMetricsHandler.mapMetricListToJson(list);
                }
                if (requestedMetricsList.isEmpty()) {
                    return "[]";
                }
                String[] requestedMetrics = requestedMetricsList.split(",");
                ArrayList requestedAggregationsFactories = new ArrayList();
                if (aggTypeList == null || aggTypeList.isEmpty()) {
                    requestedAggregationsFactories.add(DoubleAccumulator.DoubleMinimumFactory.get());
                    requestedAggregationsFactories.add(DoubleAccumulator.DoubleMaximumFactory.get());
                    requestedAggregationsFactories.add(DoubleAccumulator.DoubleSumFactory.get());
                    requestedAggregationsFactories.add(DoubleAccumulator.DoubleAverageFactory.get());
                } else {
                    block14: for (String aggregation : aggTypeList.split(",")) {
                        switch (aggregation.toLowerCase()) {
                            case "min": {
                                requestedAggregationsFactories.add(DoubleAccumulator.DoubleMinimumFactory.get());
                                continue block14;
                            }
                            case "max": {
                                requestedAggregationsFactories.add(DoubleAccumulator.DoubleMaximumFactory.get());
                                continue block14;
                            }
                            case "sum": {
                                requestedAggregationsFactories.add(DoubleAccumulator.DoubleSumFactory.get());
                                continue block14;
                            }
                            case "avg": {
                                requestedAggregationsFactories.add(DoubleAccumulator.DoubleAverageFactory.get());
                                continue block14;
                            }
                            default: {
                                this.log.warn("Invalid aggregation specified: {}", (Object)aggregation.toLowerCase());
                            }
                        }
                    }
                }
                return this.getAggregatedMetricValues(stores, requestedMetrics, requestedAggregationsFactories);
            }
            catch (Exception e) {
                throw new CompletionException(new FlinkException("Could not retrieve metrics.", (Throwable)e));
            }
        }, this.executor);
    }

    private static Collection<String> getAvailableMetrics(Collection<? extends MetricStore.ComponentMetricStore> stores) {
        HashSet<String> uniqueMetrics = new HashSet<String>();
        for (MetricStore.ComponentMetricStore componentMetricStore : stores) {
            uniqueMetrics.addAll(componentMetricStore.metrics.keySet());
        }
        return uniqueMetrics;
    }

    private static String mapMetricListToJson(Collection<String> metrics) throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        gen.writeStartArray();
        for (String m : metrics) {
            gen.writeStartObject();
            gen.writeStringField("id", m);
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.close();
        return writer.toString();
    }

    private String getAggregatedMetricValues(Collection<? extends MetricStore.ComponentMetricStore> stores, String[] requestedMetrics, List<DoubleAccumulator.DoubleAccumulatorFactory<?>> requestedAggregationsFactories) throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        gen.writeStartArray();
        for (String requestedMetric : requestedMetrics) {
            ArrayList<Double> values = new ArrayList<Double>();
            try {
                for (MetricStore.ComponentMetricStore componentMetricStore : stores) {
                    String stringValue = componentMetricStore.metrics.get(requestedMetric);
                    if (stringValue == null) continue;
                    values.add(Double.valueOf(stringValue));
                }
            }
            catch (NumberFormatException nfe) {
                this.log.warn("The metric {} is not numeric and can't be aggregated.", (Object)requestedMetric, (Object)nfe);
                continue;
            }
            if (values.isEmpty()) continue;
            gen.writeStartObject();
            gen.writeStringField("id", requestedMetric);
            for (DoubleAccumulator.DoubleAccumulatorFactory doubleAccumulatorFactory : requestedAggregationsFactories) {
                Iterator<Double> valuesIterator = values.iterator();
                Object acc = doubleAccumulatorFactory.get((Double)valuesIterator.next());
                valuesIterator.forEachRemaining(arg_0 -> acc.add(arg_0));
                gen.writeStringField(acc.getName(), String.valueOf(acc.getValue()));
            }
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.close();
        return writer.toString();
    }
}

