/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;

public class FsCompletedCheckpointStorageLocation
implements CompletedCheckpointStorageLocation {
    private static final long serialVersionUID = 1L;
    private final Path exclusiveCheckpointDir;
    private final FileStateHandle metadataFileHandle;
    private final String externalPointer;
    private transient FileSystem fs;

    public FsCompletedCheckpointStorageLocation(FileSystem fs, Path exclusiveCheckpointDir, FileStateHandle metadataFileHandle, String externalPointer) {
        this.fs = fs;
        this.exclusiveCheckpointDir = exclusiveCheckpointDir;
        this.metadataFileHandle = metadataFileHandle;
        this.externalPointer = externalPointer;
    }

    @Override
    public String getExternalPointer() {
        return this.externalPointer;
    }

    @Override
    public FileStateHandle getMetadataHandle() {
        return this.metadataFileHandle;
    }

    @Override
    public void disposeStorageLocation() throws IOException {
        if (this.fs == null) {
            this.fs = this.exclusiveCheckpointDir.getFileSystem();
        }
        this.fs.delete(this.exclusiveCheckpointDir, false);
    }
}

