/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.util.Preconditions;

public abstract class AbstractHeapState<K, N, SV, S extends State>
implements InternalKvState<K, N, SV> {
    protected final StateTable<K, N, SV> stateTable;
    protected N currentNamespace;
    protected final TypeSerializer<K> keySerializer;
    protected final TypeSerializer<SV> valueSerializer;
    protected final TypeSerializer<N> namespaceSerializer;
    private final SV defaultValue;

    protected AbstractHeapState(StateTable<K, N, SV> stateTable, TypeSerializer<K> keySerializer, TypeSerializer<SV> valueSerializer, TypeSerializer<N> namespaceSerializer, SV defaultValue) {
        this.stateTable = (StateTable)Preconditions.checkNotNull(stateTable, (String)"State table must not be null.");
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.namespaceSerializer = namespaceSerializer;
        this.defaultValue = defaultValue;
        this.currentNamespace = null;
    }

    public final void clear() {
        this.stateTable.remove(this.currentNamespace);
    }

    @Override
    public final void setCurrentNamespace(N namespace) {
        this.currentNamespace = Preconditions.checkNotNull(namespace, (String)"Namespace must not be null.");
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<SV> safeValueSerializer) throws Exception {
        Preconditions.checkNotNull((Object)serializedKeyAndNamespace);
        Preconditions.checkNotNull(safeKeySerializer);
        Preconditions.checkNotNull(safeNamespaceSerializer);
        Preconditions.checkNotNull(safeValueSerializer);
        Tuple2 keyAndNamespace = KvStateSerializer.deserializeKeyAndNamespace((byte[])serializedKeyAndNamespace, safeKeySerializer, safeNamespaceSerializer);
        SV result = this.stateTable.get(keyAndNamespace.f0, keyAndNamespace.f1);
        if (result == null) {
            return null;
        }
        return KvStateSerializer.serializeValue(result, safeValueSerializer);
    }

    @VisibleForTesting
    public StateTable<K, N, SV> getStateTable() {
        return this.stateTable;
    }

    protected SV getDefaultValue() {
        if (this.defaultValue != null) {
            return (SV)this.valueSerializer.copy(this.defaultValue);
        }
        return null;
    }
}

