/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.DefaultOperatorStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.state.filesystem.AbstractFileStateBackend;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.runtime.state.memory.MemoryBackendCheckpointStorage;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TernaryBoolean;

@PublicEvolving
public class MemoryStateBackend
extends AbstractFileStateBackend
implements ConfigurableStateBackend {
    private static final long serialVersionUID = 4109305377809414635L;
    public static final int DEFAULT_MAX_STATE_SIZE = 0x500000;
    private final int maxStateSize;
    private final TernaryBoolean asynchronousSnapshots;

    public MemoryStateBackend() {
        this(null, null, 0x500000, TernaryBoolean.UNDEFINED);
    }

    public MemoryStateBackend(boolean asynchronousSnapshots) {
        this(null, null, 0x500000, TernaryBoolean.fromBoolean((boolean)asynchronousSnapshots));
    }

    public MemoryStateBackend(int maxStateSize) {
        this(null, null, maxStateSize, TernaryBoolean.UNDEFINED);
    }

    public MemoryStateBackend(int maxStateSize, boolean asynchronousSnapshots) {
        this(null, null, maxStateSize, TernaryBoolean.fromBoolean((boolean)asynchronousSnapshots));
    }

    public MemoryStateBackend(@Nullable String checkpointPath, @Nullable String savepointPath) {
        this(checkpointPath, savepointPath, 0x500000, TernaryBoolean.UNDEFINED);
    }

    public MemoryStateBackend(@Nullable String checkpointPath, @Nullable String savepointPath, int maxStateSize, TernaryBoolean asynchronousSnapshots) {
        super(checkpointPath == null ? null : new Path(checkpointPath), savepointPath == null ? null : new Path(savepointPath));
        Preconditions.checkArgument((maxStateSize > 0 ? 1 : 0) != 0, (Object)"maxStateSize must be > 0");
        this.maxStateSize = maxStateSize;
        this.asynchronousSnapshots = asynchronousSnapshots;
    }

    private MemoryStateBackend(MemoryStateBackend original, Configuration configuration) {
        super(original.getCheckpointPath(), original.getSavepointPath(), configuration);
        this.maxStateSize = original.maxStateSize;
        this.asynchronousSnapshots = original.asynchronousSnapshots.resolveUndefined(configuration.getBoolean(CheckpointingOptions.ASYNC_SNAPSHOTS));
    }

    public int getMaxStateSize() {
        return this.maxStateSize;
    }

    public boolean isUsingAsynchronousSnapshots() {
        return this.asynchronousSnapshots.getOrDefault(((Boolean)CheckpointingOptions.ASYNC_SNAPSHOTS.defaultValue()).booleanValue());
    }

    @Override
    public MemoryStateBackend configure(Configuration config) {
        return new MemoryStateBackend(this, config);
    }

    @Override
    public CheckpointStorage createCheckpointStorage(JobID jobId) throws IOException {
        return new MemoryBackendCheckpointStorage(jobId, this.getCheckpointPath(), this.getSavepointPath(), this.maxStateSize);
    }

    @Override
    public OperatorStateBackend createOperatorStateBackend(Environment env, String operatorIdentifier) throws Exception {
        return new DefaultOperatorStateBackend(env.getUserClassLoader(), env.getExecutionConfig(), this.isUsingAsynchronousSnapshots());
    }

    @Override
    public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry) {
        TaskStateManager taskStateManager = env.getTaskStateManager();
        return new HeapKeyedStateBackend<K>(kvStateRegistry, keySerializer, env.getUserClassLoader(), numberOfKeyGroups, keyGroupRange, this.isUsingAsynchronousSnapshots(), env.getExecutionConfig(), taskStateManager.createLocalRecoveryConfig());
    }

    public String toString() {
        return "MemoryStateBackend (data in heap memory / checkpoints to JobManager) (checkpoints: '" + this.getCheckpointPath() + "', savepoints: '" + this.getSavepointPath() + "', asynchronous: " + this.asynchronousSnapshots + ", maxStateSize: " + this.maxStateSize + ")";
    }
}

