/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Iterator;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.QueryableStateOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.taskexecutor.QueryableStateConfiguration;
import org.apache.flink.runtime.taskmanager.NetworkEnvironmentConfiguration;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerServicesConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerServicesConfiguration.class);
    private final InetAddress taskManagerAddress;
    private final String[] tmpDirPaths;
    private final String[] localRecoveryStateRootDirectories;
    private final int numberOfSlots;
    private final NetworkEnvironmentConfiguration networkConfig;
    private final QueryableStateConfiguration queryableStateConfig;
    private final long configuredMemory;
    private final MemoryType memoryType;
    private final boolean preAllocateMemory;
    private final float memoryFraction;
    private final long timerServiceShutdownTimeout;
    private final boolean localRecoveryEnabled;

    public TaskManagerServicesConfiguration(InetAddress taskManagerAddress, String[] tmpDirPaths, String[] localRecoveryStateRootDirectories, boolean localRecoveryEnabled, NetworkEnvironmentConfiguration networkConfig, QueryableStateConfiguration queryableStateConfig, int numberOfSlots, long configuredMemory, MemoryType memoryType, boolean preAllocateMemory, float memoryFraction, long timerServiceShutdownTimeout) {
        this.taskManagerAddress = (InetAddress)Preconditions.checkNotNull((Object)taskManagerAddress);
        this.tmpDirPaths = (String[])Preconditions.checkNotNull((Object)tmpDirPaths);
        this.localRecoveryStateRootDirectories = (String[])Preconditions.checkNotNull((Object)localRecoveryStateRootDirectories);
        this.localRecoveryEnabled = (Boolean)Preconditions.checkNotNull((Object)localRecoveryEnabled);
        this.networkConfig = (NetworkEnvironmentConfiguration)Preconditions.checkNotNull((Object)networkConfig);
        this.queryableStateConfig = (QueryableStateConfiguration)Preconditions.checkNotNull((Object)queryableStateConfig);
        this.numberOfSlots = (Integer)Preconditions.checkNotNull((Object)numberOfSlots);
        this.configuredMemory = configuredMemory;
        this.memoryType = (MemoryType)Preconditions.checkNotNull((Object)memoryType);
        this.preAllocateMemory = preAllocateMemory;
        this.memoryFraction = memoryFraction;
        Preconditions.checkArgument((timerServiceShutdownTimeout >= 0L ? 1 : 0) != 0, (Object)"The timer service shutdown timeout must be greater or equal to 0.");
        this.timerServiceShutdownTimeout = timerServiceShutdownTimeout;
    }

    public InetAddress getTaskManagerAddress() {
        return this.taskManagerAddress;
    }

    public String[] getTmpDirPaths() {
        return this.tmpDirPaths;
    }

    public String[] getLocalRecoveryStateRootDirectories() {
        return this.localRecoveryStateRootDirectories;
    }

    public boolean isLocalRecoveryEnabled() {
        return this.localRecoveryEnabled;
    }

    public NetworkEnvironmentConfiguration getNetworkConfig() {
        return this.networkConfig;
    }

    public QueryableStateConfiguration getQueryableStateConfig() {
        return this.queryableStateConfig;
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public float getMemoryFraction() {
        return this.memoryFraction;
    }

    public MemoryType getMemoryType() {
        return this.memoryType;
    }

    public long getConfiguredMemory() {
        return this.configuredMemory;
    }

    public boolean isPreAllocateMemory() {
        return this.preAllocateMemory;
    }

    public long getTimerServiceShutdownTimeout() {
        return this.timerServiceShutdownTimeout;
    }

    public static TaskManagerServicesConfiguration fromConfiguration(Configuration configuration, InetAddress remoteAddress, boolean localCommunication) throws Exception {
        int slots = configuration.getInteger(TaskManagerOptions.NUM_TASK_SLOTS, 1);
        if (slots == -1) {
            slots = 1;
        }
        String[] tmpDirs = ConfigurationUtils.parseTempDirectories((Configuration)configuration);
        String[] localStateRootDir = ConfigurationUtils.parseLocalStateDirectories((Configuration)configuration);
        if (localStateRootDir.length == 0) {
            localStateRootDir = tmpDirs;
        }
        boolean localRecoveryMode = configuration.getBoolean(CheckpointingOptions.LOCAL_RECOVERY.key(), ((Boolean)CheckpointingOptions.LOCAL_RECOVERY.defaultValue()).booleanValue());
        NetworkEnvironmentConfiguration networkConfig = TaskManagerServicesConfiguration.parseNetworkEnvironmentConfiguration(configuration, localCommunication, remoteAddress, slots);
        QueryableStateConfiguration queryableStateConfig = TaskManagerServicesConfiguration.parseQueryableStateConfiguration(configuration);
        long configuredMemory = configuration.getLong(TaskManagerOptions.MANAGED_MEMORY_SIZE);
        TaskManagerServicesConfiguration.checkConfigParameter(configuredMemory == (Long)TaskManagerOptions.MANAGED_MEMORY_SIZE.defaultValue() || configuredMemory > 0L, configuredMemory, TaskManagerOptions.MANAGED_MEMORY_SIZE.key(), "MemoryManager needs at least one MB of memory. If you leave this config parameter empty, the system automatically pick a fraction of the available memory.");
        MemoryType memType = configuration.getBoolean(TaskManagerOptions.MEMORY_OFF_HEAP) ? MemoryType.OFF_HEAP : MemoryType.HEAP;
        boolean preAllocateMemory = configuration.getBoolean(TaskManagerOptions.MANAGED_MEMORY_PRE_ALLOCATE);
        float memoryFraction = configuration.getFloat(TaskManagerOptions.MANAGED_MEMORY_FRACTION);
        TaskManagerServicesConfiguration.checkConfigParameter(memoryFraction > 0.0f && memoryFraction < 1.0f, Float.valueOf(memoryFraction), TaskManagerOptions.MANAGED_MEMORY_FRACTION.key(), "MemoryManager fraction of the free memory must be between 0.0 and 1.0");
        long timerServiceShutdownTimeout = AkkaUtils.getTimeout(configuration).toMillis();
        return new TaskManagerServicesConfiguration(remoteAddress, tmpDirs, localStateRootDir, localRecoveryMode, networkConfig, queryableStateConfig, slots, configuredMemory, memType, preAllocateMemory, memoryFraction, timerServiceShutdownTimeout);
    }

    private static NetworkEnvironmentConfiguration parseNetworkEnvironmentConfiguration(Configuration configuration, boolean localTaskManagerCommunication, InetAddress taskManagerAddress, int slots) throws Exception {
        NettyConfig nettyConfig;
        int dataport = configuration.getInteger(TaskManagerOptions.DATA_PORT);
        TaskManagerServicesConfiguration.checkConfigParameter(dataport >= 0, dataport, TaskManagerOptions.DATA_PORT.key(), "Leave config parameter empty or use 0 to let the system choose a port automatically.");
        TaskManagerServicesConfiguration.checkConfigParameter(slots >= 1, slots, TaskManagerOptions.NUM_TASK_SLOTS.key(), "Number of task slots must be at least one.");
        int pageSize = configuration.getInteger(TaskManagerOptions.MEMORY_SEGMENT_SIZE);
        TaskManagerServicesConfiguration.checkConfigParameter(pageSize >= 4096, pageSize, TaskManagerOptions.MEMORY_SEGMENT_SIZE.key(), "Minimum memory segment size is 4096");
        TaskManagerServicesConfiguration.checkConfigParameter(MathUtils.isPowerOf2((long)pageSize), pageSize, TaskManagerOptions.MEMORY_SEGMENT_SIZE.key(), "Memory segment size must be a power of 2.");
        float networkBufFraction = configuration.getFloat(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION);
        long networkBufMin = configuration.getLong(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN);
        long networkBufMax = configuration.getLong(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX);
        TaskManagerServicesConfiguration.checkNetworkBufferConfig(pageSize, networkBufFraction, networkBufMin, networkBufMax);
        int numNetworkBuffers = configuration.getInteger(TaskManagerOptions.NETWORK_NUM_BUFFERS);
        TaskManagerServicesConfiguration.checkNetworkConfigOld(numNetworkBuffers);
        if (!TaskManagerServicesConfiguration.hasNewNetworkBufConf(configuration)) {
            networkBufMin = networkBufMax = (long)numNetworkBuffers * (long)pageSize;
        } else if (configuration.contains(TaskManagerOptions.NETWORK_NUM_BUFFERS)) {
            LOG.info("Ignoring old (but still present) network buffer configuration via {}.", (Object)TaskManagerOptions.NETWORK_NUM_BUFFERS.key());
        }
        if (!localTaskManagerCommunication) {
            InetSocketAddress taskManagerInetSocketAddress = new InetSocketAddress(taskManagerAddress, dataport);
            nettyConfig = new NettyConfig(taskManagerInetSocketAddress.getAddress(), taskManagerInetSocketAddress.getPort(), pageSize, slots, configuration);
        } else {
            nettyConfig = null;
        }
        String syncOrAsync = configuration.getString("taskmanager.network.defaultIOMode", "sync");
        IOManager.IOMode ioMode = syncOrAsync.equals("async") ? IOManager.IOMode.ASYNC : IOManager.IOMode.SYNC;
        int initialRequestBackoff = configuration.getInteger(TaskManagerOptions.NETWORK_REQUEST_BACKOFF_INITIAL);
        int maxRequestBackoff = configuration.getInteger(TaskManagerOptions.NETWORK_REQUEST_BACKOFF_MAX);
        int buffersPerChannel = configuration.getInteger(TaskManagerOptions.NETWORK_BUFFERS_PER_CHANNEL);
        int extraBuffersPerGate = configuration.getInteger(TaskManagerOptions.NETWORK_EXTRA_BUFFERS_PER_GATE);
        return new NetworkEnvironmentConfiguration(networkBufFraction, networkBufMin, networkBufMax, pageSize, ioMode, initialRequestBackoff, maxRequestBackoff, buffersPerChannel, extraBuffersPerGate, nettyConfig);
    }

    protected static void checkNetworkConfigOld(int numNetworkBuffers) {
        TaskManagerServicesConfiguration.checkConfigParameter(numNetworkBuffers > 0, numNetworkBuffers, TaskManagerOptions.NETWORK_NUM_BUFFERS.key(), "Must have at least one network buffer");
    }

    protected static void checkNetworkBufferConfig(int pageSize, float networkBufFraction, long networkBufMin, long networkBufMax) throws IllegalConfigurationException {
        TaskManagerServicesConfiguration.checkConfigParameter(networkBufFraction > 0.0f && networkBufFraction < 1.0f, Float.valueOf(networkBufFraction), TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION.key(), "Network buffer memory fraction of the free memory must be between 0.0 and 1.0");
        TaskManagerServicesConfiguration.checkConfigParameter(networkBufMin >= (long)pageSize, networkBufMin, TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN.key(), "Minimum memory for network buffers must allow at least one network buffer with respect to the memory segment size");
        TaskManagerServicesConfiguration.checkConfigParameter(networkBufMax >= (long)pageSize, networkBufMax, TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX.key(), "Maximum memory for network buffers must allow at least one network buffer with respect to the memory segment size");
        TaskManagerServicesConfiguration.checkConfigParameter(networkBufMax >= networkBufMin, networkBufMax, TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX.key(), "Maximum memory for network buffers must not be smaller than minimum memory (" + TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX.key() + ": " + networkBufMin + ")");
    }

    public static boolean hasNewNetworkBufConf(Configuration config) {
        return config.contains(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION) || config.contains(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN) || config.contains(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX) || !config.contains(TaskManagerOptions.NETWORK_NUM_BUFFERS);
    }

    private static QueryableStateConfiguration parseQueryableStateConfiguration(Configuration config) {
        Iterator proxyPorts = NetUtils.getPortRangeFromString((String)config.getString(QueryableStateOptions.PROXY_PORT_RANGE));
        Iterator serverPorts = NetUtils.getPortRangeFromString((String)config.getString(QueryableStateOptions.SERVER_PORT_RANGE));
        int numProxyServerNetworkThreads = config.getInteger(QueryableStateOptions.PROXY_NETWORK_THREADS);
        int numProxyServerQueryThreads = config.getInteger(QueryableStateOptions.PROXY_ASYNC_QUERY_THREADS);
        int numStateServerNetworkThreads = config.getInteger(QueryableStateOptions.SERVER_NETWORK_THREADS);
        int numStateServerQueryThreads = config.getInteger(QueryableStateOptions.SERVER_ASYNC_QUERY_THREADS);
        return new QueryableStateConfiguration(proxyPorts, serverPorts, numProxyServerNetworkThreads, numProxyServerQueryThreads, numStateServerNetworkThreads, numStateServerQueryThreads);
    }

    static void checkConfigParameter(boolean condition, Object parameter, String name, String errorMessage) throws IllegalConfigurationException {
        if (!condition) {
            throw new IllegalConfigurationException("Invalid configuration value for " + name + " : " + parameter + " - " + errorMessage);
        }
    }
}

