/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery;

import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.BusySpinIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SleepingIdleStrategy;

public final class TaskRunner$ {
    public static final TaskRunner$ MODULE$;

    static {
        new TaskRunner$();
    }

    public IdleStrategy createIdleStrategy(int idleCpuLevel) {
        SleepingIdleStrategy sleepingIdleStrategy;
        if (idleCpuLevel == 1) {
            sleepingIdleStrategy = new SleepingIdleStrategy(TimeUnit.MILLISECONDS.toNanos(1L));
        } else if (idleCpuLevel == 10) {
            sleepingIdleStrategy = new BusySpinIdleStrategy();
        } else {
            int spinning = 1100 * idleCpuLevel - 1000;
            int yielding = 5 * idleCpuLevel;
            int minParkNanos = 1;
            long maxParkNanos = TimeUnit.MICROSECONDS.toNanos(280 - 30 * idleCpuLevel);
            sleepingIdleStrategy = new BackoffIdleStrategy((long)spinning, (long)yielding, (long)minParkNanos, maxParkNanos);
        }
        return sleepingIdleStrategy;
    }

    private TaskRunner$() {
        MODULE$ = this;
    }
}

