/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.resources.Resource;

public class ResourceProfile
implements Serializable,
Comparable<ResourceProfile> {
    private static final long serialVersionUID = 1L;
    public static final ResourceProfile UNKNOWN = new ResourceProfile(-1.0, -1);
    private final double cpuCores;
    private final int heapMemoryInMB;
    private final int directMemoryInMB;
    private final int nativeMemoryInMB;
    private final int networkMemoryInMB;
    private final Map<String, Resource> extendedResources = new HashMap<String, Resource>(1);

    public ResourceProfile(double cpuCores, int heapMemoryInMB, int directMemoryInMB, int nativeMemoryInMB, int networkMemoryInMB, Map<String, Resource> extendedResources) {
        this.cpuCores = cpuCores;
        this.heapMemoryInMB = heapMemoryInMB;
        this.directMemoryInMB = directMemoryInMB;
        this.nativeMemoryInMB = nativeMemoryInMB;
        this.networkMemoryInMB = networkMemoryInMB;
        if (extendedResources != null) {
            this.extendedResources.putAll(extendedResources);
        }
    }

    public ResourceProfile(double cpuCores, int heapMemoryInMB) {
        this(cpuCores, heapMemoryInMB, 0, 0, 0, Collections.emptyMap());
    }

    public ResourceProfile(ResourceProfile other) {
        this(other.cpuCores, other.heapMemoryInMB, other.directMemoryInMB, other.nativeMemoryInMB, other.networkMemoryInMB, other.extendedResources);
    }

    public double getCpuCores() {
        return this.cpuCores;
    }

    public int getHeapMemoryInMB() {
        return this.heapMemoryInMB;
    }

    public int getDirectMemoryInMB() {
        return this.directMemoryInMB;
    }

    public int getNativeMemoryInMB() {
        return this.nativeMemoryInMB;
    }

    public int getNetworkMemoryInMB() {
        return this.networkMemoryInMB;
    }

    public int getMemoryInMB() {
        return this.heapMemoryInMB + this.directMemoryInMB + this.nativeMemoryInMB + this.networkMemoryInMB;
    }

    public int getOperatorsMemoryInMB() {
        return this.heapMemoryInMB + this.directMemoryInMB + this.nativeMemoryInMB;
    }

    public Map<String, Resource> getExtendedResources() {
        return Collections.unmodifiableMap(this.extendedResources);
    }

    public boolean isMatching(ResourceProfile required) {
        if (this.cpuCores >= required.getCpuCores() && this.heapMemoryInMB >= required.getHeapMemoryInMB() && this.directMemoryInMB >= required.getDirectMemoryInMB() && this.nativeMemoryInMB >= required.getNativeMemoryInMB() && this.networkMemoryInMB >= required.getNetworkMemoryInMB()) {
            for (Map.Entry<String, Resource> resource : required.extendedResources.entrySet()) {
                if (this.extendedResources.containsKey(resource.getKey()) && this.extendedResources.get(resource.getKey()).getResourceAggregateType().equals((Object)resource.getValue().getResourceAggregateType()) && !(this.extendedResources.get(resource.getKey()).getValue() < resource.getValue().getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(@Nonnull ResourceProfile other) {
        int cmp = Integer.compare(this.getMemoryInMB(), other.getMemoryInMB());
        if (cmp == 0) {
            cmp = Double.compare(this.cpuCores, other.cpuCores);
        }
        if (cmp == 0) {
            Iterator<Map.Entry<String, Resource>> thisIterator = this.extendedResources.entrySet().iterator();
            Iterator<Map.Entry<String, Resource>> otherIterator = other.extendedResources.entrySet().iterator();
            while (thisIterator.hasNext() && otherIterator.hasNext()) {
                Map.Entry<String, Resource> thisResource = thisIterator.next();
                Map.Entry<String, Resource> otherResource = otherIterator.next();
                cmp = otherResource.getKey().compareTo(thisResource.getKey());
                if (cmp != 0) {
                    return cmp;
                }
                if (!otherResource.getValue().getResourceAggregateType().equals((Object)thisResource.getValue().getResourceAggregateType())) {
                    return 1;
                }
                cmp = Double.compare(thisResource.getValue().getValue(), otherResource.getValue().getValue());
                if (cmp == 0) continue;
                return cmp;
            }
            if (thisIterator.hasNext()) {
                return 1;
            }
            if (otherIterator.hasNext()) {
                return -1;
            }
        }
        return cmp;
    }

    public int hashCode() {
        long cpuBits = Double.doubleToLongBits(this.cpuCores);
        int result = (int)(cpuBits ^ cpuBits >>> 32);
        result = 31 * result + this.heapMemoryInMB;
        result = 31 * result + this.directMemoryInMB;
        result = 31 * result + this.nativeMemoryInMB;
        result = 31 * result + this.networkMemoryInMB;
        result = 31 * result + this.extendedResources.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == ResourceProfile.class) {
            ResourceProfile that = (ResourceProfile)obj;
            return this.cpuCores == that.cpuCores && this.heapMemoryInMB == that.heapMemoryInMB && this.directMemoryInMB == that.directMemoryInMB && this.networkMemoryInMB == that.networkMemoryInMB && Objects.equals(this.extendedResources, that.extendedResources);
        }
        return false;
    }

    public String toString() {
        StringBuilder resources = new StringBuilder(this.extendedResources.size() * 10);
        for (Map.Entry<String, Resource> resource : this.extendedResources.entrySet()) {
            resources.append(", ").append(resource.getKey()).append('=').append(resource.getValue());
        }
        return "ResourceProfile{cpuCores=" + this.cpuCores + ", heapMemoryInMB=" + this.heapMemoryInMB + ", directMemoryInMB=" + this.directMemoryInMB + ", nativeMemoryInMB=" + this.nativeMemoryInMB + ", networkMemoryInMB=" + this.networkMemoryInMB + resources + '}';
    }

    static ResourceProfile fromResourceSpec(ResourceSpec resourceSpec, int networkMemory) {
        HashMap<String, Resource> copiedExtendedResources = new HashMap<String, Resource>(resourceSpec.getExtendedResources());
        return new ResourceProfile(resourceSpec.getCpuCores(), resourceSpec.getHeapMemory(), resourceSpec.getDirectMemory(), resourceSpec.getNativeMemory(), networkMemory, copiedExtendedResources);
    }
}

