/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.instance.InstanceListener;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceManager {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceManager.class);
    private final Object lock = new Object();
    private final Map<InstanceID, Instance> registeredHostsById;
    private final Map<ResourceID, Instance> registeredHostsByResource;
    private final Set<ResourceID> deadHosts;
    private final List<InstanceListener> instanceListeners = new ArrayList<InstanceListener>();
    private int totalNumberOfAliveTaskSlots;
    private volatile boolean isShutdown;

    public InstanceManager() {
        this.registeredHostsById = new LinkedHashMap<InstanceID, Instance>();
        this.registeredHostsByResource = new LinkedHashMap<ResourceID, Instance>();
        this.deadHosts = new HashSet<ResourceID>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isShutdown) {
                return;
            }
            this.isShutdown = true;
            for (Instance i : this.registeredHostsById.values()) {
                i.markDead();
            }
            this.registeredHostsById.clear();
            this.registeredHostsByResource.clear();
            this.deadHosts.clear();
            this.totalNumberOfAliveTaskSlots = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reportHeartBeat(InstanceID instanceId) {
        if (instanceId == null) {
            throw new IllegalArgumentException("InstanceID may not be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isShutdown) {
                return false;
            }
            Instance host = this.registeredHostsById.get((Object)instanceId);
            if (host == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received heartbeat from unknown TaskManager with instance ID " + instanceId.toString() + " Possibly TaskManager was marked as dead (timed-out) earlier. Reporting back that task manager is no longer known.");
                }
                return false;
            }
            host.reportHeartBeat();
            LOG.trace("Received heartbeat from TaskManager {}", (Object)host);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceID registerTaskManager(TaskManagerGateway taskManagerGateway, TaskManagerLocation taskManagerLocation, HardwareDescription resources, int numberOfSlots) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isShutdown) {
                throw new IllegalStateException("InstanceManager is shut down.");
            }
            Instance prior = this.registeredHostsByResource.get(taskManagerLocation.getResourceID());
            if (prior != null) {
                throw new IllegalStateException("Registration attempt from TaskManager at " + taskManagerLocation.addressString() + ". This connection is already registered under ID " + (Object)((Object)prior.getId()));
            }
            boolean wasDead = this.deadHosts.remove(taskManagerLocation.getResourceID());
            if (wasDead) {
                LOG.info("Registering TaskManager at " + taskManagerLocation.addressString() + " which was marked as dead earlier because of a heart-beat timeout.");
            }
            InstanceID instanceID = new InstanceID();
            Instance host = new Instance(taskManagerGateway, taskManagerLocation, instanceID, resources, numberOfSlots);
            this.registeredHostsById.put(instanceID, host);
            this.registeredHostsByResource.put(taskManagerLocation.getResourceID(), host);
            this.totalNumberOfAliveTaskSlots += numberOfSlots;
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("Registered TaskManager at %s (%s) as %s. Current number of registered hosts is %d. Current number of alive task slots is %d.", new Object[]{taskManagerLocation.getHostname(), taskManagerGateway.getAddress(), instanceID, this.registeredHostsById.size(), this.totalNumberOfAliveTaskSlots}));
            }
            host.reportHeartBeat();
            this.notifyNewInstance(host);
            return instanceID;
        }
    }

    public void unregisterTaskManager(InstanceID instanceId, boolean terminated2) {
        Instance instance = this.registeredHostsById.get((Object)instanceId);
        if (instance != null) {
            this.registeredHostsById.remove((Object)instance.getId());
            this.registeredHostsByResource.remove(instance.getTaskManagerID());
            if (terminated2) {
                this.deadHosts.add(instance.getTaskManagerID());
            }
            instance.markDead();
            this.totalNumberOfAliveTaskSlots -= instance.getTotalNumberOfSlots();
            this.notifyDeadInstance(instance);
            LOG.info("Unregistered task manager " + instance.getTaskManagerLocation().addressString() + ". Number of registered task managers " + this.getNumberOfRegisteredTaskManagers() + ". Number of available slots " + this.getTotalNumberOfSlots() + ".");
        } else {
            LOG.warn("Tried to unregister instance {} but it is not registered.", (Object)instanceId);
        }
    }

    public void unregisterAllTaskManagers() {
        for (Instance instance : this.registeredHostsById.values()) {
            this.deadHosts.add(instance.getTaskManagerID());
            instance.markDead();
            this.totalNumberOfAliveTaskSlots -= instance.getTotalNumberOfSlots();
            this.notifyDeadInstance(instance);
        }
        this.registeredHostsById.clear();
        this.registeredHostsByResource.clear();
    }

    public boolean isRegistered(InstanceID instanceId) {
        return this.registeredHostsById.containsKey((Object)instanceId);
    }

    public boolean isRegistered(ResourceID resourceId) {
        return this.registeredHostsByResource.containsKey(resourceId);
    }

    public int getNumberOfRegisteredTaskManagers() {
        return this.registeredHostsById.size();
    }

    public int getTotalNumberOfSlots() {
        return this.totalNumberOfAliveTaskSlots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAvailableSlots() {
        Object object = this.lock;
        synchronized (object) {
            int numSlots = 0;
            for (Instance i : this.registeredHostsById.values()) {
                numSlots += i.getNumberOfAvailableSlots();
            }
            return numSlots;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Instance> getAllRegisteredInstances() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<Instance>(this.registeredHostsById.values());
        }
    }

    public Instance getRegisteredInstanceById(InstanceID instanceID) {
        return this.registeredHostsById.get((Object)instanceID);
    }

    public Instance getRegisteredInstance(ResourceID ref) {
        return this.registeredHostsByResource.get(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(InstanceListener listener) {
        List<InstanceListener> list = this.instanceListeners;
        synchronized (list) {
            this.instanceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(InstanceListener listener) {
        List<InstanceListener> list = this.instanceListeners;
        synchronized (list) {
            this.instanceListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNewInstance(Instance instance) {
        List<InstanceListener> list = this.instanceListeners;
        synchronized (list) {
            for (InstanceListener listener : this.instanceListeners) {
                try {
                    listener.newInstanceAvailable(instance);
                }
                catch (Throwable t) {
                    LOG.error("Notification of new instance availability failed.", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDeadInstance(Instance instance) {
        List<InstanceListener> list = this.instanceListeners;
        synchronized (list) {
            for (InstanceListener listener : this.instanceListeners) {
                try {
                    listener.instanceDied(instance);
                }
                catch (Throwable t) {
                    LOG.error("Notification of dead instance failed.", t);
                }
            }
        }
    }
}

