/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.async;

import java.io.IOException;
import org.apache.flink.runtime.io.async.StoppableCallbackCallable;
import org.apache.flink.util.ExceptionUtils;

public abstract class AbstractAsyncCallableWithResources<V>
implements StoppableCallbackCallable<V> {
    private volatile boolean stopped = false;
    private volatile boolean called = false;
    private volatile Exception stopException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V call() throws Exception {
        V result;
        block15: {
            result = null;
            Exception collectedException = null;
            try {
                AbstractAsyncCallableWithResources abstractAsyncCallableWithResources = this;
                synchronized (abstractAsyncCallableWithResources) {
                    if (this.stopped) {
                        throw new IOException("Task was already stopped.");
                    }
                    this.called = true;
                    this.acquireResources();
                }
                result = this.performOperation();
            }
            catch (Exception ex) {
                collectedException = ex;
                return (V)collectedException;
            }
            finally {
                try {
                    this.releaseResources();
                }
                catch (Exception relEx) {
                    collectedException = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)relEx, (Throwable)collectedException);
                }
                if (collectedException == null) break block15;
                throw collectedException;
            }
        }
        return result;
    }

    protected abstract void acquireResources() throws Exception;

    protected abstract V performOperation() throws Exception;

    protected abstract void releaseResources() throws Exception;

    protected abstract void stopOperation() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() {
        AbstractAsyncCallableWithResources abstractAsyncCallableWithResources = this;
        synchronized (abstractAsyncCallableWithResources) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
        }
        if (this.called) {
            try {
                this.stopOperation();
            }
            catch (Exception stpEx) {
                this.stopException = stpEx;
            }
        } else {
            try {
                this.releaseResources();
            }
            catch (Exception relEx) {
                this.stopException = relEx;
            }
        }
    }

    @Override
    public void done(boolean canceled) {
    }

    public boolean isCalled() {
        return this.called;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public Exception getStopException() {
        return this.stopException;
    }
}

